/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.filter;

import com.enhancera.auditor.common.filter.StatusExposingServletResponse;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;

public class ContentCapturingOutputStream
extends ServletOutputStream {
    private static final FormattingLogger log = FormattingLogger.getLogger(StatusExposingServletResponse.class);
    private final OutputStream servletOutputStream;
    private final String characterEncoding;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public ContentCapturingOutputStream(String characterEncoding) {
        this(null, characterEncoding);
    }

    public ContentCapturingOutputStream(OutputStream servletOutputStream, String characterEncoding) {
        this.servletOutputStream = servletOutputStream;
        this.characterEncoding = characterEncoding;
    }

    public String getContent() {
        try {
            this.baos.flush();
            return this.baos.toString(this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e, "Wrong character encoding!", new Object[0]);
        }
        catch (IOException e) {
            log.error(e, "Error flushing capturing stream", new Object[0]);
        }
        return null;
    }

    public void write(int b) throws IOException {
        this.baos.write(b);
        if (this.servletOutputStream != null) {
            this.servletOutputStream.write(b);
        }
    }

    public void flush() throws IOException {
        this.baos.flush();
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
    }
}

