/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.database;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.java.ao.Query;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class FilterQuery {
    private final StringBuilder sqlBuilder;
    private final List<Object> queryParams;

    public static Builder builder() {
        return new Builder();
    }

    public Query createAoQuery() {
        return Query.select().where(this.sqlBuilder.toString(), this.queryParams.toArray());
    }

    protected FilterQuery(Builder builder) {
        this.sqlBuilder = builder.sqlBuilder;
        this.queryParams = builder.queryParams;
    }

    public static class Builder {
        private StringBuilder sqlBuilder = new StringBuilder("1=1");
        private List<Object> queryParams = new ArrayList<Object>();

        public Builder addInClauseForColumnValues(String columnName, @Nullable Set<String> values) {
            if (values != null && !values.isEmpty()) {
                this.sqlBuilder.append(" AND ");
                this.sqlBuilder.append(String.format(columnName + " IN (%s)", Builder.preparePlaceHolders(values.size())));
                this.queryParams.addAll(values);
            }
            return this;
        }

        public Builder addSqlEventTimeFilteringByTime(@Nullable DateTime time) {
            if (time != null) {
                this.sqlBuilder.append(" AND ");
                this.sqlBuilder.append(String.format("EVENT_TIME = ?", new Object[0]));
                this.queryParams.add(time.getMillis());
            }
            return this;
        }

        public Builder addSqlEventTimeFilteringByInterval(@Nullable Interval interval) {
            if (interval != null) {
                this.sqlBuilder.append(" AND EVENT_TIME ");
                if (interval.getStartMillis() == 0L) {
                    this.sqlBuilder.append("< ?");
                    this.queryParams.add(interval.getEndMillis());
                } else {
                    this.sqlBuilder.append(String.format("BETWEEN ? AND ?", new Object[0]));
                    this.queryParams.add(interval.getStartMillis());
                    this.queryParams.add(interval.getEndMillis());
                }
            }
            return this;
        }

        public Builder addSqlFilteringBySearchQuery(@Nullable String searchQuery) {
            if (!Strings.isNullOrEmpty(searchQuery)) {
                this.sqlBuilder.append(" AND ");
                String likeExpression = "%" + searchQuery.toLowerCase() + "%";
                this.sqlBuilder.append(String.format("SEARCHABLE_DETAILS LIKE ?", new Object[0]));
                this.queryParams.add(likeExpression);
            }
            return this;
        }

        private static String preparePlaceHolders(int length) {
            return String.join((CharSequence)",", Collections.nCopies(length, "?"));
        }

        public FilterQuery build() {
            return new FilterQuery(this);
        }

        private Builder() {
        }
    }
}

