/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Facility implements Comparable<Facility>
{
    KERN(0, "KERN"),
    USER(1, "USER"),
    MAIL(2, "MAIL"),
    DAEMON(3, "DAEMON"),
    AUTH(4, "AUTH"),
    SYSLOG(5, "SYSLOG"),
    LPR(6, "LPR"),
    NEWS(7, "NEWS"),
    UUCP(8, "UUCP"),
    CRON(9, "CRON"),
    AUTHPRIV(10, "AUTHPRIV"),
    FTP(11, "FTP"),
    NTP(12, "NTP"),
    AUDIT(13, "AUDIT"),
    ALERT(14, "ALERT"),
    CLOCK(15, "CLOCK"),
    LOCAL0(16, "LOCAL0"),
    LOCAL1(17, "LOCAL1"),
    LOCAL2(18, "LOCAL2"),
    LOCAL3(19, "LOCAL3"),
    LOCAL4(20, "LOCAL4"),
    LOCAL5(21, "LOCAL5"),
    LOCAL6(22, "LOCAL6"),
    LOCAL7(23, "LOCAL7");

    private static final Map<String, Facility> facilityFromLabel;
    private static final Map<Integer, Facility> facilityFromNumericalCode;
    private final int numericalCode;
    @Nonnull
    private final String label;

    private Facility(int numericalCode, String label) {
        this.numericalCode = numericalCode;
        this.label = label;
    }

    @Nonnull
    public static Facility fromNumericalCode(int numericalCode) throws IllegalArgumentException {
        Facility facility = facilityFromNumericalCode.get(numericalCode);
        if (facility == null) {
            throw new IllegalArgumentException("Invalid facility '" + numericalCode + "'");
        }
        return facility;
    }

    @Nullable
    public static Facility fromLabel(String label) throws IllegalArgumentException {
        if (label == null || label.isEmpty()) {
            return null;
        }
        Facility facility = facilityFromLabel.get(label);
        if (facility == null) {
            throw new IllegalArgumentException("Invalid facility '" + label + "'");
        }
        return facility;
    }

    public int numericalCode() {
        return this.numericalCode;
    }

    public String label() {
        return this.label;
    }

    public static Comparator<Facility> comparator() {
        return new Comparator<Facility>(){

            @Override
            public int compare(Facility f1, Facility f2) {
                return Integer.compare(f1.numericalCode, f2.numericalCode);
            }
        };
    }

    static {
        facilityFromLabel = new HashMap<String, Facility>();
        facilityFromNumericalCode = new HashMap<Integer, Facility>();
        for (Facility facility : Facility.values()) {
            facilityFromLabel.put(facility.label, facility);
            facilityFromNumericalCode.put(facility.numericalCode, facility);
        }
    }
}

