/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class DarkColorSchemeColorsBySpaceKeyTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(DarkColorSchemeColorsBySpaceKeyTransformer.class);
    private static final String DARK_THEME_COLOR_SCHEME_PROPERTIES_SUFFIX = ".dark";
    private static final ImmutableList<String> DARK_COLOUR_SCHEME_PROPERTIES = ImmutableList.of("property.style.topbarcolour", "property.style.breadcrumbstextcolour", "property.style.headerbuttonbasebgcolour", "property.style.headerbuttontextcolour", "property.style.topbarmenuselectedbgcolour", "property.style.topbarmenuselectedtextcolour", "property.style.topbarmenuitemtextcolour", "property.style.menuitemselectedbgcolour", "property.style.menuitemselectedtextcolour", "property.style.searchfieldbgcolour", "property.style.searchfieldtextcolour", "property.style.menuselectedbgcolour", new String[]{"property.style.menuitemtextcolour", "property.style.headingtextcolour", "property.style.linkcolour", "property.style.bordercolour"});
    private final ColourSchemeManager colourSchemeManager;

    public DarkColorSchemeColorsBySpaceKeyTransformer(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        ColourScheme scheme;
        ColourScheme colourScheme = scheme = args.isEmpty() ? this.colourSchemeManager.getGlobalColourScheme() : this.colourSchemeManager.getSpaceColourScheme(args.get(0));
        if (scheme == null) {
            log.error("Color scheme not found for space key: " + args.get(0), new Object[0]);
            return ConvertionUtils.nullValues(DARK_COLOUR_SCHEME_PROPERTIES.size());
        }
        return ConvertionUtils.values(DARK_COLOUR_SCHEME_PROPERTIES.stream().map(value -> scheme.get(value + DARK_THEME_COLOR_SCHEME_PROPERTIES_SUFFIX)).toArray());
    }
}

