/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.confluence.CreateContentService;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class BlueprintNameByIdTransformer
extends SingleArgumentTransformer {
    private final I18nResolver i18nResolver;
    private final CreateContentService createContentService;
    private final LocaleManager localeManager;

    public BlueprintNameByIdTransformer(I18nResolver i18nResolver, CreateContentService createContentService, LocaleManager localeManager) {
        this.i18nResolver = i18nResolver;
        this.createContentService = createContentService;
        this.localeManager = localeManager;
    }

    @Override
    public List<String> transform(String arg) {
        Optional<String> i18BlueprintName = this.createContentService.getBlueprintName(UUID.fromString(arg));
        return i18BlueprintName.isPresent() ? ConvertionUtils.values(this.i18nResolver.getText(this.localeManager.getSiteDefaultLocale(), i18BlueprintName.get())) : this.returnIfNull();
    }
}

