/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.primitives.Ints;
import java.util.List;

public class RateLimitingTypeByCapacityTransformer
extends SingleArgumentTransformer {
    @Override
    public List<String> transform(String arg) {
        String result;
        Integer capacity = Ints.tryParse(arg);
        if (capacity == null) {
            return this.returnIfNull();
        }
        switch (capacity) {
            case -1: {
                result = "Allow unlimited requests";
                break;
            }
            case 0: {
                result = "Block all requests";
                break;
            }
            default: {
                result = "Limit requests";
            }
        }
        return ConvertionUtils.values(result);
    }
}

