/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class SpaceAnalyticsPermissionsByJsonTransformer
extends SingleArgumentTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(SpaceAnalyticsPermissionsByJsonTransformer.class);
    private final UserManager userManager;
    private final GroupManager groupManager;

    public SpaceAnalyticsPermissionsByJsonTransformer(UserManager userManager, GroupManager groupManager) {
        this.userManager = userManager;
        this.groupManager = groupManager;
    }

    @Override
    public List<String> transform(String arg) {
        String restrictionsGsonArray = "[" + arg + "]";
        Gson gson = new Gson();
        Type listType = new TypeToken<List<Restriction>>(){}.getType();
        List objects = (List)gson.fromJson(restrictionsGsonArray, listType);
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        for (Restriction restriction : objects) {
            if (restriction.userId != null) {
                UserKey userKey = new UserKey(restriction.userId);
                UserProfile userProfile = this.userManager.getUserProfile(userKey);
                if (userProfile == null) continue;
                users.add(userProfile.getUsername());
                continue;
            }
            if (restriction.groupName == null) continue;
            try {
                Group group = this.groupManager.getGroup(restriction.groupName);
                if (group == null) continue;
                groups.add(group.getName());
            }
            catch (EntityException e) {
                log.error("Error getting group by name %s", restriction.groupName);
            }
        }
        return ConvertionUtils.values(users, groups);
    }

    private class Restriction {
        private final String userId;
        private final String groupName;

        private Restriction(String userId, String groupName) {
            this.userId = userId;
            this.groupName = groupName;
        }
    }
}

