/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.rest;

import com.atlassian.sal.api.user.UserManager;
import com.enhancera.auditor.common.DataOption;
import com.enhancera.auditor.common.DataOptionType;
import com.enhancera.auditor.common.DataOptionsProvider;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.UserUtils;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/filter")
public class FilterDataResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(FilterDataResource.class);
    private final DataOptionsProvider dataOptionsProvider;
    private final UserUtils userUtils;
    private final UserManager userManager;
    private final SettingsService settingsService;

    public FilterDataResource(DataOptionsProvider dataOptionsProvider, UserUtils userUtils, UserManager userManager, SettingsService settingsService) {
        this.dataOptionsProvider = dataOptionsProvider;
        this.userUtils = userUtils;
        this.userManager = userManager;
        this.settingsService = settingsService;
    }

    @Path(value="/{option}/{param}")
    @GET
    @Produces(value={"application/json"})
    public Response getObjectOptions(@PathParam(value="option") DataOptionType option, @PathParam(value="param") String param) {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to view audit trail.", user);
            return Response.serverError().status(403).build();
        }
        Set<DataOption> dataOptions = this.dataOptionsProvider.findDataOptions(option, param, false);
        return Response.ok(dataOptions).build();
    }
}

