/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.util;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.util.LicenseCheckResult;
import java.util.ResourceBundle;

public class LicenseChecker {
    private static final String LICENSE_PARAM = "auditor.license";
    private final HostAppService hostAppService;

    public LicenseChecker(HostAppService hostAppService) {
        this.hostAppService = hostAppService;
    }

    public LicenseCheckResult checkLicense(Option<PluginLicense> license) {
        if (!license.isDefined()) {
            return new LicenseCheckResult(false, this.getText("auditor.license.no.license"));
        }
        if (!((PluginLicense)license.get()).isValid()) {
            String errorMessage = this.getText("auditor.license.invalid");
            if (((PluginLicense)license.get()).getError().isDefined()) {
                switch ((LicenseError)((PluginLicense)license.get()).getError().get()) {
                    case EXPIRED: {
                        errorMessage = this.getText("auditor.license.expired");
                        break;
                    }
                    case TYPE_MISMATCH: {
                        errorMessage = this.getText("auditor.license.type.mismatch");
                        break;
                    }
                    case USER_MISMATCH: {
                        errorMessage = this.getText("auditor.license.too.many.users");
                        break;
                    }
                    case VERSION_MISMATCH: {
                        errorMessage = this.getText("auditor.license.support.expired.for.version");
                    }
                }
            }
            return new LicenseCheckResult(false, errorMessage);
        }
        return new LicenseCheckResult(true);
    }

    public String getText(String key) {
        ResourceBundle rb = this.hostAppService.getResourceBundle();
        return rb.getString(key);
    }
}

