/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public abstract class GenericObjectParametersByIdTransformer<T>
extends SingleArgumentTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(GenericObjectParametersByIdTransformer.class);

    public abstract String parametersName();

    public abstract List<String> parametersValue(T var1);

    public abstract String objectName();

    public abstract T objectValue(long var1) throws Exception;

    public String formatParametersValue(List<String> value) {
        return value.get(0);
    }

    public String parametersValuesSeparator() {
        return ", ";
    }

    @Override
    public List<String> transform(String arg) {
        ImmutableList<String> ids = ImmutableList.copyOf(arg.split(", ?"));
        if (ids.size() == 1) {
            return this.transformId((String)ids.get(0));
        }
        return ConvertionUtils.values(Joiner.on(this.parametersValuesSeparator()).skipNulls().join(Iterables.transform(ids, new Function<String, String>(){

            @Override
            public String apply(String s) {
                if (s.isEmpty()) {
                    return null;
                }
                return GenericObjectParametersByIdTransformer.this.formatParametersValue(GenericObjectParametersByIdTransformer.this.transformId(s));
            }
        })));
    }

    private List<String> transformId(String stringId) {
        try {
            if (Strings.isNullOrEmpty(stringId)) {
                return this.returnIfNull();
            }
            Long id = Long.parseLong(stringId);
            T object = this.objectValue(id);
            if (object == null) {
                log.debug("%s not found for id %s.", this.objectName(), id);
                return this.returnIfNull();
            }
            List<String> objectParameters = this.parametersValue(object);
            log.debug("%s %s for id %s is '%s'.", this.objectName(), this.parametersName(), id, objectParameters);
            return objectParameters;
        }
        catch (Exception e) {
            log.error(e, "Error getting %s by id %s", this.objectName(), stringId);
            return this.returnIfNull();
        }
    }
}

