/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.UserImpl;
import com.enhancera.auditor.common.settings.PersistentSettingsServiceImpl;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FileUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.joda.time.Duration;

@Path(value="/settings")
public class SettingsRestResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(SettingsRestResource.class);
    private final UserManager userManager;
    private final UserUtils userUtils;
    private final SettingsService settingsService;
    private final FileUtils fileUtils;

    public SettingsRestResource(UserManager userManager, UserUtils userUtils, SettingsService settingsService, FileUtils fileUtils) {
        this.userManager = userManager;
        this.userUtils = userUtils;
        this.settingsService = settingsService;
        this.fileUtils = fileUtils;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getSettings() {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to view settings.", user);
            return Response.serverError().status(403).build();
        }
        log.debug("Loaded settings %s", settings);
        return Response.ok((Object)settings).build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @ReadOnlyAccessAllowed
    public Response setSettings(@FormParam(value="retentionPeriod") int retentionPeriod, @FormParam(value="numberOfEventsPerPage") int numberOfEventsPerPage, @FormParam(value="isSystemAdminAccessOnly") boolean isSystemAdminAccessOnly, @FormParam(value="notifiedUsers") List<String> notifiedUsers, @FormParam(value="writeToSyslog") boolean writeToSyslog, @FormParam(value="syslogHost") String syslogHost, @Nullable @FormParam(value="syslogFacility") Integer syslogFacility, @Nullable @FormParam(value="syslogLevel") Integer syslogLevel, @FormParam(value="writeToFile") boolean writeToFile, @FormParam(value="filePath") String filePath) {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to edit settings.", user);
            return Response.serverError().status(403).build();
        }
        log.debug("Set retention period to %d", retentionPeriod);
        settings.setRetentionPeriod(Duration.standardDays(retentionPeriod));
        settings.setNumberOfEventsPerPage(numberOfEventsPerPage);
        settings.setSystemAdminAccessOnly(isSystemAdminAccessOnly);
        settings.setNotifiedUsers(this.getUsers(notifiedUsers));
        settings.setWriteToSyslog(writeToSyslog);
        settings.setSyslogHost(syslogHost);
        settings.setSyslogFacility(syslogFacility != null ? syslogFacility : -1);
        settings.setSyslogLevel(syslogLevel != null ? syslogLevel : -1);
        settings.setWriteToFile(writeToFile);
        settings.setFilePath(filePath);
        List<String> errors = this.validate(settings);
        if (errors.isEmpty()) {
            this.settingsService.setSettings(settings);
        }
        return Response.ok(errors).build();
    }

    private List<String> validate(Settings settings) {
        int syslogLevel;
        ArrayList<String> errors = new ArrayList<String>();
        if (settings.isWriteToFile() && !this.fileUtils.initFile(settings.getFilePath())) {
            errors.add("Invalid log file path.");
        }
        if ((syslogLevel = settings.getSyslogLevel()) == -1 || ((ImmutableCollection)((Object)PersistentSettingsServiceImpl.OLD_TO_NEW_SEVERITY_MAP.keySet())).contains(syslogLevel)) {
            errors.add("Severity and facility lists were updated after the latest plugin version installation. Please <a href=\"javascript:window.location.reload(true)\">reload the page</a> and try again.");
        }
        return errors;
    }

    private List<User> getUsers(List<String> usernames) {
        ArrayList<User> users = new ArrayList<User>();
        for (String username : usernames) {
            UserProfile user = this.userManager.getUserProfile(username);
            if (user == null) continue;
            users.add(new UserImpl(user.getUsername(), user.getFullName(), user.getEmail()));
        }
        return users;
    }
}

