/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.database;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.PagedEvents;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class FakeDataLayerImpl
implements DataLayer {
    private static final FormattingLogger log = FormattingLogger.getLogger(FakeDataLayerImpl.class);
    private static final DateTime NOW = DateTime.parse("2015-08-23");
    private static final Duration HOUR = Duration.standardHours(1L);
    private static final Duration DAY = Duration.standardDays(1L);
    private static final Duration WEEK = Duration.standardDays(7L);
    private static final List<Event> EVENTS = ImmutableList.of(new Event("adam", "1.2.3.4", NOW.minus(HOUR), "Users", "User created", "max", ImmutableList.of(new EventDetail("User id", null, "max", false), new EventDetail("User name", null, "Max Braverman", false), new EventDetail("Email", null, "max@braverman.name", false))), new Event("adam", "1.2.3.4", NOW.minus(HOUR), "Users", "User created", "max", ImmutableList.of(new EventDetail("User id", null, "max", false), new EventDetail("User name", null, "Max Braverman", false), new EventDetail("Email", null, "max@braverman.name", false))), new Event("adam", "1.2.3.4", NOW.minus(HOUR), "Users", "User created", "max", ImmutableList.of(new EventDetail("User id", null, "max", false), new EventDetail("User name", null, "Max Braverman", false), new EventDetail("Email", null, "max@braverman.name", false))), new Event("julia", "10.0.0.7", NOW.minus(DAY), "Spaces", "Space details edited", "FAMILY", ImmutableList.of(new EventDetail("Space name", "My Cool Family", "My Crazy Family", true))), new Event("julia", "10.0.0.7", NOW.minus(DAY), "Spaces", "Space details edited", "FAMILY", ImmutableList.of(new EventDetail("Space name", "My Cool Family", "My Crazy Family", true))), new Event("julia", "10.0.0.7", NOW.minus(DAY), "Spaces", "Space details edited", "FAMILY", ImmutableList.of(new EventDetail("Space name", "My Cool Family", "My Crazy Family", true))), new Event("adam", "1.2.3.4", NOW.minus(WEEK), "Users", "User created", "haddie", ImmutableList.of(new EventDetail("User id", null, "haddie", false), new EventDetail("User name", null, "Haddie Braverman", false), new EventDetail("Email", null, "haddie@braverman.name", false))));

    @Override
    public void writeEvent(Event event) {
        log.debug("PRETEND INSERTING EVENT %s", event);
    }

    @Override
    public List<Event> readEvents(EventCriteria criteria) {
        log.debug("RETURN EVENTS %s", EVENTS);
        return EVENTS;
    }

    @Override
    public PagedEvents readPagedEvents(EventCriteria criteria, int pageNumber, int numberOfResultsPerPage) {
        List<Event> events = this.filterEvents(criteria);
        int startIndex = Math.min(events.size(), Math.max(0, (pageNumber - 1) * numberOfResultsPerPage));
        int endIndex = Math.min(startIndex + numberOfResultsPerPage, events.size());
        List<Event> pagedEvents = events.subList(startIndex, endIndex);
        log.debug("RETURN EVENTS [%d:%d] %s", startIndex, endIndex, pagedEvents);
        return new PagedEvents(pagedEvents, startIndex, endIndex, pageNumber, numberOfResultsPerPage, events.size());
    }

    private List<Event> filterEvents(EventCriteria criteria) {
        ArrayList<Event> filteredEvents = Lists.newArrayList();
        for (Event event : EVENTS) {
            if (!this.matches(event, criteria)) continue;
            filteredEvents.add(event);
        }
        return filteredEvents;
    }

    private boolean matches(Event event, EventCriteria criteria) {
        if (criteria.getTime() != null && !criteria.getTime().equals(event.getTime()) || criteria.getCategories() != null && !criteria.getCategories().contains(event.getCategory()) || criteria.getSummaries() != null && !criteria.getSummaries().contains(event.getSummary()) || criteria.getObjects() != null && !criteria.getObjects().contains(event.getObject()) || criteria.getAuthors() != null && !criteria.getAuthors().contains(event.getAuthor()) || criteria.getIpAddresses() != null && !criteria.getIpAddresses().contains(event.getIpAddress()) || criteria.getInterval() != null && !criteria.getInterval().contains(event.getTime())) {
            return false;
        }
        for (EventDetail detail : event.getDetails()) {
            if (!this.matches(detail, criteria)) continue;
            return true;
        }
        String q = criteria.getSearchQuery();
        return this.contains(event.getAuthor(), q) || this.contains(event.getCategory(), q) || this.contains(event.getSummary(), q) || this.contains(event.getObject(), q) || this.contains(event.getIpAddress(), q);
    }

    private boolean matches(EventDetail detail, EventCriteria criteria) {
        String q = criteria.getSearchQuery();
        return this.contains(detail.getName(), q) || this.contains(detail.getOldValue(), q) || this.contains(detail.getNewValue(), q);
    }

    private boolean contains(String value, String q) {
        return q == null || value != null && value.toLowerCase().contains(q.toLowerCase());
    }

    @Override
    public void deleteEvents(EventCriteria criteria) {
        log.debug("PRETEND DELETING EVENTS FOR CRITERIA " + criteria, new Object[0]);
    }
}

