/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UsersByPermissionAndSpaceTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(UsersByPermissionAndSpaceTransformer.class);
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;

    public UsersByPermissionAndSpaceTransformer(SpaceManager spaceManager, SpacePermissionManager spacePermissionManager) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    @Override
    public String transformSingle(List<String> args) {
        List permissions;
        Preconditions.checkArgument((args.size() == 1 || args.size() == 2 ? 1 : 0) != 0);
        String permissionType = args.get(0);
        Space space = null;
        if (args.size() > 1) {
            String spaceKey = args.get(1);
            space = this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                log.debug("Space not found for key %s.", spaceKey);
                return null;
            }
            permissions = space.getPermissions();
        } else {
            permissions = this.spacePermissionManager.getGlobalPermissions(permissionType);
        }
        ArrayList userNames = Lists.newArrayList();
        for (SpacePermission permission : permissions) {
            if (!permissionType.equals(permission.getType()) || permission.getUserSubject() == null) continue;
            userNames.add(permission.getUserSubject().getName());
        }
        Collections.sort(userNames);
        return Joiner.on((String)", ").join((Iterable)userNames);
    }
}

