/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.user.UserAccessor;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;

public class UserGroupListByNameTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(UserGroupListByNameTransformer.class);
    private final UserAccessor userAccessor;

    public UserGroupListByNameTransformer(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public String transformSingle(List<String> args) {
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0);
        String userName = args.get(0);
        List groupNames = this.userAccessor.getGroupNamesForUserName(userName);
        String groups = Joiner.on((String)", ").join((Iterable)groupNames);
        log.debug("User groups for user %s are '%s'.", userName, groups);
        return groups;
    }
}

