/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Preconditions;
import java.util.List;

public class UserEmailByKeyTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(UserEmailByKeyTransformer.class);
    private final UserManager userManager;

    public UserEmailByKeyTransformer(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public String transformSingle(List<String> args) {
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0);
        String userKeyString = args.get(0);
        UserKey userKey = new UserKey(userKeyString);
        UserProfile profile = this.userManager.getUserProfile(userKey);
        if (profile == null) {
            log.debug("User profile not found for key %s.", userKeyString);
            return null;
        }
        String userEmail = profile.getEmail();
        log.debug("User email for key %s is '%s'.", userKey, userEmail);
        return userEmail;
    }
}

