/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionDefaultsStoreFactory;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GroupsByPermissionAndSpaceTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(GroupsByPermissionAndSpaceTransformer.class);
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;
    private final SpacePermissionDefaultsStoreFactory spacePermissionDefaultsStoreFactory;

    public GroupsByPermissionAndSpaceTransformer(SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, SpacePermissionDefaultsStoreFactory spacePermissionDefaultsStoreFactory) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.spacePermissionDefaultsStoreFactory = spacePermissionDefaultsStoreFactory;
    }

    @Override
    public String transformSingle(List<String> args) {
        List permissions;
        Preconditions.checkArgument((args.size() == 1 || args.size() == 2 ? 1 : 0) != 0);
        String permissionType = args.get(0);
        Space space = null;
        if (args.size() > 1) {
            String spaceKey = args.get(1);
            Space space2 = space = spaceKey != null ? this.spaceManager.getSpace(spaceKey) : this.spacePermissionDefaultsStoreFactory.createStore().getTemplateSpace();
            if (space == null) {
                log.debug("Space not found for key %s.", spaceKey);
                return null;
            }
            permissions = space.getPermissions();
        } else {
            permissions = this.spacePermissionManager.getGlobalPermissions(permissionType);
        }
        ArrayList groupNames = Lists.newArrayList();
        for (SpacePermission permission : permissions) {
            if (!permissionType.equals(permission.getType()) || permission.getGroup() == null) continue;
            groupNames.add(permission.getGroup());
        }
        Collections.sort(groupNames);
        return Joiner.on((String)", ").join((Iterable)groupNames);
    }
}

