/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.sal.api.message.I18nResolver;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class BlueprintNameByIdTransformer
extends SingleArgumentTransformer {
    private final ContentBlueprintManager contentBlueprintManager;
    private final I18nResolver i18nResolver;

    public BlueprintNameByIdTransformer(ContentBlueprintManager contentBlueprintManager, I18nResolver i18nResolver) {
        this.contentBlueprintManager = contentBlueprintManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public List<String> transform(String arg) {
        UUID id = UUID.fromString(arg);
        ContentBlueprint blueprint = (ContentBlueprint)this.contentBlueprintManager.getById(id);
        return blueprint == null ? this.returnIfNull() : ConvertionUtils.values(this.i18nResolver.getText(Locale.ENGLISH, blueprint.getI18nNameKey()));
    }
}

