/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.util;

import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.tika.Tika;

public class FileUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(FileUtils.class);
    private final SettingsService settingsService;

    public FileUtils(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public boolean initFile(String pathString) {
        Settings currentSettings = this.settingsService.getSettings();
        if (currentSettings.isWriteToFile() && currentSettings.getFilePath().equals(pathString)) {
            return true;
        }
        try {
            Tika tika;
            String mimeType;
            if (pathString == null) {
                log.error("File path is null", new Object[0]);
                return false;
            }
            Path path = Paths.get(pathString, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && ((mimeType = (tika = new Tika()).detect(path)) == null || !mimeType.equals("text/plain") && !mimeType.equals("text/x-log"))) {
                return false;
            }
            FileUtils.writeToFile(("Auditor log file initialized." + System.lineSeparator()).getBytes(), path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static synchronized void writeToFile(byte[] meessageBytes, Path filePath) throws IOException {
        Files.write(filePath, meessageBytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    }
}

