/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.settings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.UserImpl;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;

public class PersistentSettingsServiceImpl
extends SettingsService {
    private static final FormattingLogger log = FormattingLogger.getLogger(PersistentSettingsServiceImpl.class);
    private static final String RETENTION_PERIOD_PARAM = "retentionPeriod";
    private static final String NUMBER_OF_EVENTS_PER_PAGE_PARAM = "numberOfEventsPerPage";
    private static final String SYSTEM_ADMIN_ACCESS_ONLY = "systemAdminAccessOnly";
    private static final String NOTIFIED_USERS = "notifiedUsers";
    private static final String WRITE_TO_SYSLOG = "writeToSyslog";
    private static final String SYSLOG_HOST = "syslogHost";
    private static final String SYSLOG_FACILITY = "syslogFacility";
    private static final String SYSLOG_LEVEL = "syslogLevel";
    private static final String WRITE_TO_FILE = "writeToFile";
    private static final String FILE_PATH = "filePath";
    public static final ImmutableMap<Integer, Integer> OLD_TO_NEW_SEVERITY_MAP = ImmutableMap.builder().put((Object)10000, (Object)Severity.DEBUG.numericalCode()).put((Object)20000, (Object)Severity.INFORMATIONAL.numericalCode()).put((Object)30000, (Object)Severity.WARNING.numericalCode()).put((Object)40000, (Object)Severity.ERROR.numericalCode()).put((Object)50000, (Object)Severity.EMERGENCY.numericalCode()).build();
    private static final ImmutableMap<Integer, Integer> OLD_TO_NEW_FACILITY_MAP = ImmutableMap.builder().put((Object)0, (Object)Facility.KERN.numericalCode()).put((Object)8, (Object)Facility.USER.numericalCode()).put((Object)16, (Object)Facility.MAIL.numericalCode()).put((Object)24, (Object)Facility.DAEMON.numericalCode()).put((Object)32, (Object)Facility.AUTH.numericalCode()).put((Object)40, (Object)Facility.SYSLOG.numericalCode()).put((Object)48, (Object)Facility.LPR.numericalCode()).put((Object)56, (Object)Facility.NEWS.numericalCode()).put((Object)64, (Object)Facility.UUCP.numericalCode()).put((Object)72, (Object)Facility.CRON.numericalCode()).put((Object)80, (Object)Facility.AUTHPRIV.numericalCode()).put((Object)88, (Object)Facility.FTP.numericalCode()).put((Object)128, (Object)Facility.LOCAL0.numericalCode()).put((Object)136, (Object)Facility.LOCAL1.numericalCode()).put((Object)144, (Object)Facility.LOCAL2.numericalCode()).put((Object)152, (Object)Facility.LOCAL3.numericalCode()).put((Object)160, (Object)Facility.LOCAL4.numericalCode()).put((Object)168, (Object)Facility.LOCAL5.numericalCode()).put((Object)176, (Object)Facility.LOCAL6.numericalCode()).put((Object)184, (Object)Facility.LOCAL7.numericalCode()).build();
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;

    public PersistentSettingsServiceImpl(PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public Settings getSettings() {
        return (Settings)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Settings>(){

            public Settings doInTransaction() {
                String filePathString;
                String writeToFileString;
                String syslogHostString;
                String writeToSyslogString;
                List notifiedUsersStrings;
                String systemAdminAccessOnlyString;
                String numberOfEventsPerPageString;
                PluginSettings pluginSettings = PersistentSettingsServiceImpl.this.pluginSettingsFactory.createGlobalSettings();
                Settings settings = new Settings();
                String retentionPeriodString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.RETENTION_PERIOD_PARAM));
                if (retentionPeriodString != null) {
                    settings.setRetentionPeriod(Duration.parse((String)retentionPeriodString));
                }
                if ((numberOfEventsPerPageString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NUMBER_OF_EVENTS_PER_PAGE_PARAM))) != null) {
                    settings.setNumberOfEventsPerPage(Integer.parseInt(numberOfEventsPerPageString));
                }
                if ((systemAdminAccessOnlyString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSTEM_ADMIN_ACCESS_ONLY))) != null) {
                    settings.setSystemAdminAccessOnly(Boolean.valueOf(systemAdminAccessOnlyString));
                }
                if ((notifiedUsersStrings = (List)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NOTIFIED_USERS))) != null) {
                    settings.setNotifiedUsers(Lists.transform((List)notifiedUsersStrings, (Function)new Function<String, User>(){

                        public User apply(String s) {
                            return PersistentSettingsServiceImpl.this.userFromString(s);
                        }
                    }));
                }
                if ((writeToSyslogString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_SYSLOG))) != null) {
                    settings.setWriteToSyslog(Boolean.valueOf(writeToSyslogString));
                }
                if ((syslogHostString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_HOST))) != null) {
                    settings.setSyslogHost(syslogHostString);
                }
                String syslogFacilityString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_FACILITY));
                String syslogLevelString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_LEVEL));
                if (syslogLevelString != null) {
                    int syslogLevel = Integer.parseInt(syslogLevelString);
                    if (OLD_TO_NEW_SEVERITY_MAP.containsKey((Object)syslogLevel)) {
                        syslogLevel = (Integer)OLD_TO_NEW_SEVERITY_MAP.get((Object)syslogLevel);
                        pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_LEVEL), (Object)String.valueOf(syslogLevel));
                        if (syslogFacilityString != null) {
                            int syslogFacility = Integer.parseInt(syslogFacilityString);
                            if (OLD_TO_NEW_FACILITY_MAP.containsKey((Object)syslogFacility)) {
                                syslogFacility = (Integer)OLD_TO_NEW_FACILITY_MAP.get((Object)syslogFacility);
                                syslogFacilityString = String.valueOf(syslogFacility);
                                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_FACILITY), (Object)syslogFacilityString);
                            }
                        }
                    }
                    settings.setSyslogLevel(syslogLevel);
                }
                if (syslogFacilityString != null) {
                    settings.setSyslogFacility(Integer.parseInt(syslogFacilityString));
                }
                if ((writeToFileString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_FILE))) != null) {
                    settings.setWriteToFile(Boolean.valueOf(writeToFileString));
                }
                if ((filePathString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.FILE_PATH))) != null) {
                    settings.setFilePath(filePathString);
                }
                return settings;
            }
        });
    }

    @Override
    public void setSettings(final Settings settings) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                PluginSettings pluginSettings = PersistentSettingsServiceImpl.this.pluginSettingsFactory.createGlobalSettings();
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.RETENTION_PERIOD_PARAM), (Object)settings.getRetentionPeriod().toString());
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NUMBER_OF_EVENTS_PER_PAGE_PARAM), (Object)String.valueOf(settings.getNumberOfEventsPerPage()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSTEM_ADMIN_ACCESS_ONLY), (Object)String.valueOf(settings.isSystemAdminAccessOnly()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NOTIFIED_USERS), new ArrayList(Lists.transform(settings.getNotifiedUsers(), (Function)new Function<User, String>(){

                    public String apply(User user) {
                        return PersistentSettingsServiceImpl.this.userToString(user);
                    }
                })));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_SYSLOG), (Object)String.valueOf(settings.isWriteToSyslog()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_HOST), (Object)String.valueOf(settings.getSyslogHost()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_FACILITY), (Object)String.valueOf(settings.getSyslogFacility()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_LEVEL), (Object)String.valueOf(settings.getSyslogLevel()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_FILE), (Object)String.valueOf(settings.isWriteToFile()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.FILE_PATH), (Object)String.valueOf(settings.getFilePath()));
                return null;
            }
        });
        this.setChanged();
        this.notifyObservers();
    }

    private String userToString(User user) {
        String fullName = user.getFullName() == null ? "" : user.getFullName();
        String email = user.getEmail() == null ? "" : user.getEmail();
        return String.format("username:%s&fullName:%s&email:%s", user.getUsername(), fullName, email);
    }

    private User userFromString(String s) {
        Matcher m = Pattern.compile("username:(.*)&fullName:(.+)?&email:(.+)?").matcher(s);
        if (m.matches()) {
            return new UserImpl(m.group(1), m.group(2), m.group(3));
        }
        log.error("Error reading stored user: " + s, new Object[0]);
        return null;
    }

    private static final String getParameterKey(String param) {
        return Settings.class.getName() + "." + param;
    }
}

