/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserManager;
import com.enhancera.auditor.common.BackupRestoringEventTracker;
import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.PagedEvents;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.RequestUtils;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/trail")
public class AuditLogRestResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(AuditLogRestResource.class);
    private final DataLayer dataLayer;
    private final AuditLogWriter logWriter;
    private final UserManager userManager;
    private final UserUtils userUtils;
    private final SettingsService settingsService;
    private final BackupRestoringEventTracker backupRestoringEventTracker;

    public AuditLogRestResource(DataLayer dataLayer, AuditLogWriter logWriter, UserManager userManager, UserUtils userUtils, SettingsService settingsService, BackupRestoringEventTracker backupRestoringEventTracker) {
        this.dataLayer = dataLayer;
        this.logWriter = logWriter;
        this.userManager = userManager;
        this.userUtils = userUtils;
        this.settingsService = settingsService;
        this.backupRestoringEventTracker = backupRestoringEventTracker;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getTrail(@QueryParam(value="page") Integer page, @QueryParam(value="query") String query, @QueryParam(value="fromTime") Long fromTime, @QueryParam(value="toTime") Long toTime, @QueryParam(value="users") List<String> users, @QueryParam(value="ips") List<String> ips, @QueryParam(value="categories") List<String> categories, @QueryParam(value="summaries") List<String> summaries, @QueryParam(value="objects") List<String> objects) {
        this.backupRestoringEventTracker.check();
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to view audit trail.", user);
            return Response.serverError().status(403).build();
        }
        int pageNumber = page == null ? 1 : page;
        int resultsPerPage = settings.getNumberOfEventsPerPage();
        log.debug("Showing %d results on page %d", resultsPerPage, pageNumber);
        EventCriteria criteria = EventCriteria.create(query, fromTime, toTime, users, ips, categories, summaries, objects);
        PagedEvents events = this.dataLayer.readPagedEvents(criteria, pageNumber, resultsPerPage);
        return Response.ok((Object)events).build();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    public Response delete(@Context HttpServletRequest request) {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to delete audit trail.", user);
            return Response.serverError().status(403).build();
        }
        log.info("Deleting all stored log entities", new Object[0]);
        Event event = new Event(username, RequestUtils.extractIpAddress(request), DateTime.now(), "Auditor", "Audit log deleted", "Auditor", (List<EventDetail>)ImmutableList.of());
        this.backupRestoringEventTracker.clean();
        this.dataLayer.deleteEvents(EventCriteria.ALL);
        this.logWriter.write(event);
        return Response.ok().build();
    }
}

