/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.notifications;

import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.notifications.MailQueue;
import com.enhancera.auditor.common.notifications.Notification;
import com.enhancera.auditor.common.notifications.Notifier;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class EmailNotifier
implements Notifier {
    private static final FormattingLogger log = FormattingLogger.getLogger(EmailNotifier.class);
    private final MailQueue mailQueue;
    private final HostAppService hostAppService;

    public EmailNotifier(MailQueue mailQueue, HostAppService hostAppService) {
        this.mailQueue = mailQueue;
        this.hostAppService = hostAppService;
    }

    @Override
    public void notify(Notification notification) {
        this.mailQueue.add(this.getMailList(notification));
    }

    private List<MailQueueItem> getMailList(Notification notification) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        String message = notification.getMessage();
        for (User user : notification.getUsers()) {
            Email email = null;
            try {
                email = new Email(user.getEmail());
            }
            catch (IllegalArgumentException e) {
                log.error(e, "Invalid user's email", new Object[0]);
            }
            if (email == null) continue;
            email.setSubject("Auditor for " + this.hostAppService.getApplicationName() + " daily summary");
            email.setBody(message);
            email.setMimeType(notification.getMimeType());
            builder.add((Object)new SingleMailQueueItem(email));
        }
        return builder.build();
    }
}

