/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.logwriters;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventFormatter;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FileUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileAuditLogWriter
implements AuditLogWriter {
    private static final FormattingLogger log = FormattingLogger.getLogger(FileAuditLogWriter.class);
    private final SettingsService settingsService;
    private final EventFormatter eventFormatter;

    public FileAuditLogWriter(SettingsService settingsService, EventFormatter eventFormatter) {
        this.settingsService = settingsService;
        this.eventFormatter = eventFormatter;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void write(Event event) {
        Settings settings = this.settingsService.getSettings();
        if (settings.isWriteToFile()) {
            Path path = Paths.get(settings.getFilePath(), new String[0]);
            try {
                FileUtils.writeToFile((this.eventFormatter.format(event) + System.lineSeparator()).getBytes(), path);
            }
            catch (IOException e) {
                log.error(e, "Error writing event to the file: " + settings.getFilePath(), new Object[0]);
            }
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

