/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.filter;

import com.enhancera.auditor.common.EventTemplate;
import com.enhancera.auditor.common.RequestData;
import com.enhancera.auditor.common.RequestProcessor;
import com.enhancera.auditor.common.RequestType;
import com.enhancera.auditor.common.ResponseData;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.filter.RestReadingServletRequest;
import com.enhancera.auditor.common.filter.StatusExposingServletResponse;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.JsonProxy;
import com.enhancera.auditor.common.util.RequestBody;
import com.enhancera.auditor.common.util.RequestUtils;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;

public class RestEventsFilter
implements Filter {
    private static final FormattingLogger log = FormattingLogger.getLogger(RestEventsFilter.class);
    private FilterConfig config;
    private final UserUtils userUtils;
    private final RequestProcessor requestProcessor;

    public RestEventsFilter(UserUtils userUtils, RequestProcessor requestProcessor) {
        this.userUtils = userUtils;
        this.requestProcessor = requestProcessor;
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
        this.config = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            log.info("Either request or response are non-HTTP.Don't know how to deal with them, so just skipping.", new Object[0]);
            return;
        }
        RestReadingServletRequest wrappedRequest = new RestReadingServletRequest((HttpServletRequest)request);
        try {
            EventTemplate eventTemplate;
            StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response, this.requestProcessor.getErrorPatterns());
            String url = wrappedRequest.getRequestURI();
            String ipAddress = RequestUtils.extractIpAddress((HttpServletRequest)wrappedRequest);
            User author = this.userUtils.getCurrentUser();
            ListMultimap<String, String> requestParameters = RequestUtils.getParametersMultimap((HttpServletRequest)request);
            ListMultimap<String, String> requestHeaders = RequestUtils.getHeadersMultimap((HttpServletRequest)request);
            DateTime time = DateTime.now();
            String method = wrappedRequest.getMethod();
            String restBody = wrappedRequest.getBody();
            JsonProxy json = new JsonProxy(restBody);
            RequestBody body = new RequestBody(restBody);
            if (json.isEmpty() && !Strings.isNullOrEmpty((String)restBody)) {
                requestParameters.putAll(RequestUtils.parsePostDataParameters(restBody));
            }
            RequestData requestData = new RequestData(author, ipAddress, time, method, url, requestParameters, requestHeaders, json, body, RequestType.REST);
            try {
                eventTemplate = this.requestProcessor.preprocess(requestData);
            }
            catch (Exception e) {
                log.error(e, "Error occurred preprocessing request data: " + requestData, new Object[0]);
                chain.doFilter((ServletRequest)wrappedRequest, response);
                return;
            }
            if (eventTemplate != null) {
                chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
                ResponseData responseData = wrappedResponse.getResponseData();
                log.debug("Auditor action: %s, responseData: %s", url, responseData);
                try {
                    this.requestProcessor.postprocess(eventTemplate, requestData, responseData);
                }
                catch (Exception e) {
                    log.error(e, "Error occurred postprocessing request data: " + requestData, new Object[0]);
                }
            } else {
                chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
            }
        }
        catch (Exception e) {
            log.error(e, "Error processing web request", new Object[0]);
            chain.doFilter((ServletRequest)wrappedRequest, response);
        }
    }
}

