/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.user.UserAccessor;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class UsersFromListByGroupTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(UsersFromListByGroupTransformer.class);
    private final UserAccessor userAccessor;

    public UsersFromListByGroupTransformer(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public String transformSingle(List<String> args) {
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
        String groupName = args.get(0);
        ImmutableList usernames = ImmutableList.copyOf((Object[])args.get(1).split("\\s*,\\s*"));
        ArrayList members = Lists.newArrayList();
        for (String username : usernames) {
            String trimmedUsername = username.trim();
            if (!this.userAccessor.hasMembership(groupName, trimmedUsername)) continue;
            members.add(trimmedUsername);
        }
        String addedMembers = Joiner.on((String)", ").join((Iterable)members);
        log.debug("Added members for group %s among '%s' are '%s'.", groupName, args.get(1), addedMembers);
        return addedMembers;
    }
}

