/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.content.service.BlogPostService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public class TrashContentParametersByIdTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(TrashContentParametersByIdTransformer.class);
    private final PageManager pageManager;
    private final BlogPostService blogPostService;
    private final AttachmentManager attachmentManager;

    public TrashContentParametersByIdTransformer(PageManager pageManager, BlogPostService blogPostService, AttachmentManager attachmentManager) {
        this.pageManager = pageManager;
        this.blogPostService = blogPostService;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        String spaceKey = args.get(0);
        long id = Long.parseLong(args.get(1));
        String type = null;
        String title = null;
        Page page = this.pageManager.getPage(id);
        BlogPost blogPost = this.blogPostService.getIdBlogPostLocator(id).getBlogPost();
        Attachment attachment = this.attachmentManager.getAttachment(id);
        if (page != null && page.isDeleted() && page.getSpaceKey().equals(spaceKey)) {
            type = "Page";
            title = page.getTitle();
        } else if (blogPost != null && blogPost.isDeleted() && blogPost.getSpaceKey().equals(spaceKey)) {
            type = "Blog post";
            title = blogPost.getTitle();
        } else if (attachment != null && attachment.isDeleted() && attachment.getSpace() != null && attachment.getSpace().getKey().equals(spaceKey)) {
            type = "Attachment";
            title = attachment.getTitle();
        } else {
            log.error("Error obtaining trash content by parameters: " + args, new Object[0]);
        }
        return ConvertionUtils.values(type, title);
    }
}

