/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TrashContentBySpaceKeyTransformer
extends SingleArgumentTransformer {
    private static final int LIST_ITEMS_THRESHOLD = 100;
    private final TrashManager trashManager;
    private final SpaceManager spaceManager;

    public TrashContentBySpaceKeyTransformer(TrashManager trashManager, SpaceManager spaceManager) {
        this.trashManager = trashManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public List<String> transform(String arg) {
        Space space = this.spaceManager.getSpace(arg);
        int size = this.trashManager.getNumberOfItemsInTrash(space);
        List items = new ArrayList();
        if (size <= 100) {
            items = Lists.transform((List)this.trashManager.getTrashContents(space, 0, size), (Function)new Function<ContentEntityObject, String>(){

                public String apply(ContentEntityObject contentEntityObject) {
                    return contentEntityObject.getTitle();
                }
            });
        }
        return ConvertionUtils.values(size, Joiner.on((String)", ").join(items));
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(2);
    }
}

