/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Preconditions;
import java.util.List;

public class SpaceNameByKeyTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(SpaceNameByKeyTransformer.class);
    private final SpaceManager spaceManager;

    public SpaceNameByKeyTransformer(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public String transformSingle(List<String> args) {
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0);
        String spaceKey = args.get(0);
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.debug("Space not found for key %s.", spaceKey);
            return null;
        }
        String spaceName = space.getName();
        log.debug("Space name for key %s is '%s'.", spaceKey, spaceName);
        return spaceName;
    }
}

