/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.spring.container.ContainerManager;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Preconditions;
import java.util.List;

public class MailServerNameByIdTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(MailServerNameByIdTransformer.class);

    @Override
    public String transformSingle(List<String> args) {
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0);
        MailServerManager mailServerManager = (MailServerManager)ContainerManager.getComponent((String)"mailServerManager");
        String stringId = args.get(0);
        try {
            Long id = Long.parseLong(stringId);
            MailServer mailServer = mailServerManager.getMailServer(id);
            if (mailServer == null) {
                log.debug("Mail server not found for id %s.", id);
                return null;
            }
            String serverName = mailServer.getName();
            log.debug("Mail server name for id %s is '%s'.", id, serverName);
            return serverName;
        }
        catch (Exception e) {
            log.error("Error getting mail server by id %s: %s", stringId, e);
            return null;
        }
    }
}

