/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.cache.ThreadLocalCache;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Preconditions;
import java.util.List;

public class GlobalGeneralSettingsTransformer
implements Transformer {
    private final SettingsManager settingsManager;
    private final FormatSettingsManager formatSettingsManager;

    public GlobalGeneralSettingsTransformer(SettingsManager settingsManager, FormatSettingsManager formatSettingsManager) {
        this.settingsManager = settingsManager;
        this.formatSettingsManager = formatSettingsManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        Preconditions.checkArgument((boolean)args.isEmpty());
        ThreadLocalCache.flush();
        Settings settings = this.settingsManager.getGlobalSettings();
        return ConvertionUtils.values(settings.getSiteTitle(), settings.getBaseUrl(), settings.getCustomContactMessage(), settings.isShowContactAdministratorsForm(), settings.getIndexingLanguage(), settings.getDefaultEncoding(), this.formatSettingsManager.getTimeFormat(), this.formatSettingsManager.getDateTimeFormat(), this.formatSettingsManager.getDateFormat(), this.formatSettingsManager.getLongNumberFormat(), this.formatSettingsManager.getDecimalNumberFormat(), settings.getAttachmentMaxSize(), settings.getMaxAttachmentsInUI(), settings.isGzippingResponse(), settings.getConfluenceHttpParameters().isEnabled(), settings.getConfluenceHttpParameters().getConnectionTimeout(), settings.getConfluenceHttpParameters().getSocketTimeout());
    }
}

