/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.cache.ThreadLocalCache;
import com.atlassian.confluence.setup.settings.CustomHtmlSettings;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Preconditions;
import java.util.List;

public class GlobalCustomHtmlSettingsTransformer
implements Transformer {
    private final SettingsManager settingsManager;

    public GlobalCustomHtmlSettingsTransformer(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        Preconditions.checkArgument((boolean)args.isEmpty());
        ThreadLocalCache.flush();
        Settings settings = this.settingsManager.getGlobalSettings();
        CustomHtmlSettings htmlSettings = settings.getCustomHtmlSettings();
        return ConvertionUtils.values(htmlSettings.getBeforeHeadEnd(), htmlSettings.getAfterBodyStart(), htmlSettings.getBeforeBodyEnd());
    }
}

