/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public class ColorSchemeColorsBySpaceKeyTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(ColorSchemeColorsBySpaceKeyTransformer.class);
    private final ColourSchemeManager colourSchemeManager;

    public ColorSchemeColorsBySpaceKeyTransformer(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        ColourScheme scheme;
        ColourScheme colourScheme = scheme = args.size() == 0 ? this.colourSchemeManager.getGlobalColourScheme() : this.colourSchemeManager.getSpaceColourScheme(args.get(0));
        if (scheme == null) {
            log.error("Color scheme not found for space key: " + args.get(0), new Object[0]);
            return ConvertionUtils.nullValues(21);
        }
        return ConvertionUtils.values(scheme.get("property.style.topbarcolour"), scheme.get("property.style.breadcrumbstextcolour"), scheme.get("property.style.headerbuttonbasebgcolour"), scheme.get("property.style.headerbuttontextcolour"), scheme.get("property.style.topbarmenuselectedbgcolour"), scheme.get("property.style.topbarmenuselectedtextcolour"), scheme.get("property.style.topbarmenuitemtextcolour"), scheme.get("property.style.menuitemselectedbgcolour"), scheme.get("property.style.menuitemselectedtextcolour"), scheme.get("property.style.searchfieldbgcolour"), scheme.get("property.style.searchfieldtextcolour"), scheme.get("property.style.menuselectedbgcolour"), scheme.get("property.style.menuitemtextcolour"), scheme.get("property.style.headingtextcolour"), scheme.get("property.style.spacenamecolour"), scheme.get("property.style.linkcolour"), scheme.get("property.style.bordercolour"), scheme.get("property.style.navbgcolour"), scheme.get("property.style.navtextcolour"), scheme.get("property.style.navselectedbgcolour"), scheme.get("property.style.navselectedtextcolour"));
    }
}

