/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.UserImpl;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.RequestUtils;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class ConfluenceUserUtils
implements UserUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceUserUtils.class);
    private final GroupManager groupManager;
    private final UserAccessor userAccessor;
    private final SpacePermissionManager spacePermissionManager;

    public ConfluenceUserUtils(GroupManager groupManager, UserAccessor userAccessor, SpacePermissionManager spacePermissionManager) {
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spacePermissionManager;
    }

    @Override
    public User getCurrentUser() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return user != null ? new UserImpl(user.getName()) : RequestUtils.UNKNOWN_USER;
    }

    @Override
    public List<User> getAdmins() {
        HashSet<User> admins = new HashSet<User>();
        admins.addAll(this.getUsersByPermission("ADMINISTRATECONFLUENCE"));
        admins.addAll(this.getUsersByPermission("SYSTEMADMINISTRATOR"));
        return ImmutableList.copyOf(admins);
    }

    @Override
    public List<User> getSystemAdmins() {
        return this.getUsersByPermission("SYSTEMADMINISTRATOR");
    }

    private List<User> getUsersByPermission(String permissionType) {
        List permissions = this.spacePermissionManager.getGlobalPermissions(permissionType);
        HashSet<User> users = new HashSet<User>();
        for (SpacePermission permission : permissions) {
            if (!permissionType.equals(permission.getType())) continue;
            if (permission.getUserSubject() != null) {
                ConfluenceUser user = permission.getUserSubject();
                users.add(this.getUser(user));
            }
            if (permission.getGroup() == null) continue;
            users.addAll(this.getUsersFromGroup(permission.getGroup()));
        }
        return ImmutableList.copyOf(users);
    }

    private List<User> getUsersFromGroup(String groupName) {
        Object users = ImmutableList.of();
        try {
            Group group = this.groupManager.getGroup(groupName);
            if (group != null) {
                users = Lists.transform((List)ImmutableList.copyOf((Iterable)this.userAccessor.getMembers(group)), (Function)new Function<ConfluenceUser, User>(){

                    public User apply(@Nullable ConfluenceUser user) {
                        return user == null ? null : ConfluenceUserUtils.this.getUser(user);
                    }
                });
            }
        }
        catch (EntityException e) {
            log.error(e, "Unexpected Error retrieving confluence-administrators group", new Object[0]);
        }
        return users;
    }

    private User getUser(ConfluenceUser user) {
        return new UserImpl(user.getName(), user.getFullName(), user.getEmail());
    }
}

