/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.util;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.UserImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestUtils {
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String X_CLIENT_IP = "X-Client-IP";
    public static final String PARAM_SORT_PARAMS = "sortParams";
    public static final String ID_PARAM = "id";
    public static final String ISSUE_KEY_JSON_PARAM = "key";
    public static final User UNKNOWN_USER = new UserImpl("unknown");

    public static ListMultimap<String, String> getHeadersMultimap(HttpServletRequest req) {
        LinkedListMultimap result = LinkedListMultimap.create();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration headerValues = req.getHeaders(name);
            while (headerValues.hasMoreElements()) {
                result.put((Object)name, headerValues.nextElement());
            }
        }
        return result;
    }

    public static ListMultimap<String, String> getParametersMultimap(HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        LinkedListMultimap result = LinkedListMultimap.create();
        for (Map.Entry entry : parameterMap.entrySet()) {
            for (String value : (String[])entry.getValue()) {
                result.put(entry.getKey(), (Object)value);
            }
        }
        return result;
    }

    public static ListMultimap<String, String> parsePostDataParameters(String data) {
        Preconditions.checkNotNull((Object)data);
        LinkedListMultimap result = LinkedListMultimap.create();
        for (String part : data.split("&")) {
            String[] pair = part.split("=");
            if (pair.length != 2) continue;
            result.put((Object)pair[0], (Object)pair[1]);
        }
        return result;
    }

    public static String extractIpAddress(@Nullable HttpServletRequest httpRequest) {
        String result = "-";
        if (httpRequest == null) {
            return result;
        }
        return RequestUtils.extractProxyIpAddress(httpRequest).orElse(httpRequest.getRemoteAddr());
    }

    private static Optional<String> extractProxyIpAddress(HttpServletRequest httpRequest) {
        Optional<String> result = RequestUtils.getClientIpHeaderValue(X_FORWARDED_FOR_HEADER, httpRequest);
        if (!result.isPresent()) {
            result = RequestUtils.getClientIpHeaderValue(X_CLIENT_IP, httpRequest);
        }
        return result;
    }

    private static Optional<String> getClientIpHeaderValue(String headerName, HttpServletRequest httpRequest) {
        String headerValue = httpRequest.getHeader(headerName);
        if (headerValue != null) {
            return Optional.of(X_FORWARDED_FOR_HEADER.equals(headerName) && headerValue.contains(",") ? headerValue.split(",")[0].trim() : headerValue);
        }
        return Optional.empty();
    }

    public static void redirectToLogin(HttpServletRequest request, HttpServletResponse response, LoginUriProvider loginUriProvider) throws IOException {
        response.sendRedirect(loginUriProvider.getLoginUri(RequestUtils.getUri(request)).toASCIIString());
    }

    private static URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private RequestUtils() {
    }
}

