/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.enhancera.auditor.common.transformers.WhitelistExpressionByIdTransformer;
import com.enhancera.auditor.common.transformers.WhitelistParametersByIdTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class WhitelistUpdateParametersByIdTransformer
extends WhitelistParametersByIdTransformer {
    private final WhitelistExpressionByIdTransformer expressionByIdTransformer;
    private static final Map<WhitelistType, String> whitelistTypes = ImmutableMap.of((Object)WhitelistType.APPLICATION_LINK, (Object)"Application link", (Object)WhitelistType.DOMAIN_NAME, (Object)"Domain name", (Object)WhitelistType.EXACT_URL, (Object)"Exact match", (Object)WhitelistType.WILDCARD_EXPRESSION, (Object)"Wildcard expression", (Object)WhitelistType.REGULAR_EXPRESSION, (Object)"Regular expression");

    public WhitelistUpdateParametersByIdTransformer(WhitelistService whitelistService, WhitelistExpressionByIdTransformer expressionByIdTransformer) {
        super(whitelistService);
        this.expressionByIdTransformer = expressionByIdTransformer;
    }

    @Override
    public String parametersName() {
        return "update parameters";
    }

    @Override
    public List<String> parametersValue(WhitelistRule whitelist) {
        return ConvertionUtils.values(this.expressionByIdTransformer.parametersValue(whitelist), whitelistTypes.get(whitelist.getType()), whitelist.isAllowInbound());
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(3);
    }
}

