/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.extras.api.ProductLicense;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.DateFormatter;
import java.util.List;

public abstract class LicenseDetailsTransformer
implements Transformer {
    private final DateFormatter dateFormatter;

    public abstract ProductLicense getLicense(List<String> var1);

    public LicenseDetailsTransformer(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    @Override
    public List<String> transform(List<String> args) {
        ProductLicense license = this.getLicense(args);
        return license == null ? ConvertionUtils.nullValues(7) : ConvertionUtils.values(license.getOrganisation().getName(), this.dateFormatter.format(license.getPurchaseDate()), license.isEvaluation() ? "Evaluation" : license.getLicenseType().name(), license.isUnlimitedNumberOfUsers() ? "Unlimited" : Integer.valueOf(license.getMaximumNumberOfUsers()), this.dateFormatter.format(license.getExpiryDate()), license.getSupportEntitlementNumber(), license.getServerId());
    }
}

