/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.notifications;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.notifications.EmailNotifier;
import com.enhancera.auditor.common.notifications.Notifications;
import com.enhancera.auditor.common.settings.SettingsService;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class NotificationTask
implements Runnable {
    private final Notifications notifications;
    private final EmailNotifier emailNotifier;
    private final DataLayer dataLayer;
    private final SettingsService settingsService;

    public NotificationTask(Notifications notifications, EmailNotifier emailNotifier, DataLayer dataLayer, SettingsService settingsService) {
        this.notifications = notifications;
        this.emailNotifier = emailNotifier;
        this.dataLayer = dataLayer;
        this.settingsService = settingsService;
    }

    @Override
    public void run() {
        List<User> notifiedUsers = this.settingsService.getSettings().getNotifiedUsers();
        if (notifiedUsers.isEmpty()) {
            return;
        }
        DateTime from = DateTime.now().minus((ReadableDuration)Duration.standardDays((long)1L));
        List<Event> events = this.dataLayer.readEvents(EventCriteria.builder().setInterval(new Interval((ReadableInstant)from, (ReadableInstant)DateTime.now())).build());
        if (!events.isEmpty()) {
            this.emailNotifier.notify(this.notifications.getEventSummaryNotification(events, notifiedUsers));
        }
    }
}

