/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.logwriters;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class DatabaseAuditLogWriter
implements AuditLogWriter {
    private static final FormattingLogger log = FormattingLogger.getLogger(DatabaseAuditLogWriter.class);
    private static final Duration CLEANUP_CHECK_PERIOD = Duration.standardHours((long)6L);
    private final DataLayer dataLayer;
    private final SettingsService settingsService;
    private DateTime lastCleanupTime = DateTime.parse((String)"1970-01-01");

    public DatabaseAuditLogWriter(DataLayer dataLayer, SettingsService settingsService) {
        this.dataLayer = dataLayer;
        this.settingsService = settingsService;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void write(Event event) {
        log.debug("Writing event %s to database", event.getSummary());
        this.dataLayer.writeEvent(event);
        DateTime now = DateTime.now();
        if (this.lastCleanupTime.isBefore((ReadableInstant)now.minus((ReadableDuration)CLEANUP_CHECK_PERIOD))) {
            this.lastCleanupTime = now;
            Duration retentionPeriod = this.settingsService.getSettings().getRetentionPeriod();
            if (retentionPeriod.isLongerThan((ReadableDuration)Duration.ZERO)) {
                log.debug("Clear events older than %s", retentionPeriod);
                this.dataLayer.deleteEvents(EventCriteria.before(now.minus((ReadableDuration)retentionPeriod)));
            }
        }
    }

    @Override
    public void clear() {
        log.debug("Clearing the database", new Object[0]);
        this.dataLayer.deleteEvents(EventCriteria.ALL);
    }
}

