/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.database;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.PagedEvents;
import com.enhancera.auditor.common.ao.DetailEntity;
import com.enhancera.auditor.common.ao.EventEntity;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class ActiveObjectsDataLayerImpl
implements DataLayer,
Observer {
    private static final FormattingLogger log = FormattingLogger.getLogger(ActiveObjectsDataLayerImpl.class);
    private final ActiveObjects ao;
    private final SettingsService settingsService;

    public ActiveObjectsDataLayerImpl(ActiveObjects ao, SettingsService settingsService) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.settingsService = settingsService;
        settingsService.addObserver(this);
    }

    @Override
    public void writeEvent(Event event) {
        EventEntity entity = this.saveAsEntity(event);
        log.debug("Saved entity %s", entity);
    }

    @Override
    public List<Event> readEvents(EventCriteria criteria) {
        Query pagedQuery = this.filter(Query.select(), criteria).order("EVENT_TIME DESC");
        EventEntity[] entities = (EventEntity[])this.ao.find(EventEntity.class, pagedQuery);
        ArrayList events = Lists.newArrayList();
        for (EventEntity entity : entities) {
            Event event = this.convertFromEntity(entity);
            events.add(event);
        }
        return events;
    }

    @Override
    public PagedEvents readPagedEvents(EventCriteria criteria, int pageNumber, int numberOfResultsPerPage) {
        Query countQuery = this.filter(Query.select(), criteria);
        int totalEventCount = this.ao.count(EventEntity.class, countQuery);
        int startIndex = Math.min(totalEventCount, Math.max(0, (pageNumber - 1) * numberOfResultsPerPage));
        int endIndex = Math.min(startIndex + numberOfResultsPerPage, totalEventCount);
        Query pagedQuery = this.filter(Query.select(), criteria).order("EVENT_TIME DESC").limit(numberOfResultsPerPage).offset(startIndex);
        EventEntity[] entities = (EventEntity[])this.ao.find(EventEntity.class, pagedQuery);
        ArrayList events = Lists.newArrayList();
        for (EventEntity entity : entities) {
            Event event = this.convertFromEntity(entity);
            events.add(event);
        }
        log.debug("Loaded events %s", events);
        return new PagedEvents(events, startIndex, endIndex, pageNumber, numberOfResultsPerPage, totalEventCount);
    }

    @VisibleForTesting
    public Query filter(Query query, EventCriteria criteria) {
        if (criteria.isEmpty()) {
            return query;
        }
        StringBuilder builder = new StringBuilder("1=1");
        if (criteria.getTime() != null) {
            builder.append(" AND ");
            builder.append(String.format("EVENT_TIME = %d", criteria.getTime().getMillis()));
        }
        if (criteria.getInterval() != null) {
            builder.append(" AND EVENT_TIME ");
            if (criteria.getInterval().getStartMillis() == 0L) {
                builder.append("< ").append(criteria.getInterval().getEndMillis());
            } else {
                builder.append(String.format("BETWEEN %d AND %d", criteria.getInterval().getStartMillis(), criteria.getInterval().getEndMillis()));
            }
        }
        if (criteria.getAuthors() != null && !criteria.getAuthors().isEmpty()) {
            builder.append(" AND ");
            builder.append(String.format("AUTHOR IN ('%s')", Joiner.on((String)"', '").join(criteria.getAuthors())));
        }
        if (criteria.getIpAddresses() != null && !criteria.getIpAddresses().isEmpty()) {
            builder.append(" AND ");
            builder.append(String.format("IP_ADDRESS IN ('%s')", Joiner.on((String)"', '").join(criteria.getIpAddresses())));
        }
        if (criteria.getCategories() != null && !criteria.getCategories().isEmpty()) {
            builder.append(" AND ");
            builder.append(String.format("CATEGORY IN ('%s')", Joiner.on((String)"', '").join(criteria.getCategories())));
        }
        if (criteria.getSummaries() != null && !criteria.getSummaries().isEmpty()) {
            builder.append(" AND ");
            builder.append(String.format("SUMMARY IN ('%s')", Joiner.on((String)"', '").join(criteria.getSummaries())));
        }
        if (criteria.getObjects() != null && !criteria.getObjects().isEmpty()) {
            builder.append(" AND ");
            builder.append(String.format("OBJECT IN ('%s')", Joiner.on((String)"', '").join(criteria.getObjects())));
        }
        if (!Strings.isNullOrEmpty((String)criteria.getSearchQuery())) {
            builder.append(" AND ");
            String likeExpression = "%" + criteria.getSearchQuery().toLowerCase() + "%";
            builder.append(String.format("SEARCHABLE_DETAILS LIKE '%s'", likeExpression));
        }
        query = query.where(builder.toString(), new Object[0]);
        return query;
    }

    @Override
    public void update(Observable o, Object arg) {
        Duration retentionPeriod = this.settingsService.getSettings().getRetentionPeriod();
        if (retentionPeriod.getMillis() > 0L) {
            this.deleteEvents(EventCriteria.before(DateTime.now().minus((ReadableDuration)retentionPeriod)));
        }
    }

    @Override
    public void deleteEvents(EventCriteria criteria) {
        EventEntity[] entities;
        Query query = this.filter(Query.select(), criteria).limit(999);
        int count = this.ao.count(EventEntity.class, query);
        log.info("%d event entities to be deleted", count);
        do {
            for (EventEntity entity : entities = (EventEntity[])this.ao.find(EventEntity.class, query)) {
                this.ao.deleteWithSQL(DetailEntity.class, "EVENT_ID = ?", new Object[]{entity.getID()});
            }
            this.ao.delete((RawEntity[])entities);
        } while (entities.length > 0);
    }

    private EventEntity saveAsEntity(Event event) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("AUTHOR", event.getAuthor());
        eventParams.put("IP_ADDRESS", event.getIpAddress());
        eventParams.put("EVENT_TIME", event.getTime().getMillis());
        eventParams.put("CATEGORY", event.getCategory());
        eventParams.put("SUMMARY", event.getSummary());
        eventParams.put("OBJECT", event.getObject());
        eventParams.put("SEARCHABLE_DETAILS", event.toSearchableString());
        EventEntity eventEntity = (EventEntity)this.ao.create(EventEntity.class, eventParams);
        for (EventDetail detail : event.getDetails()) {
            HashMap<String, Object> detailParams = new HashMap<String, Object>();
            detailParams.put("NAME", detail.getName());
            detailParams.put("OLD_VALUE", detail.getOldValue());
            detailParams.put("NEW_VALUE", detail.getNewValue());
            detailParams.put("DIFF", detail.isDiff());
            detailParams.put("EVENT_ID", eventEntity.getID());
            this.ao.create(DetailEntity.class, detailParams);
        }
        return eventEntity;
    }

    private Event convertFromEntity(EventEntity eventEntity) {
        ArrayList eventDetails = Lists.newArrayList();
        for (DetailEntity detailEntity : eventEntity.getDetails()) {
            eventDetails.add(new EventDetail(detailEntity.getName(), detailEntity.getOldValue(), detailEntity.getNewValue(), detailEntity.isDiff()));
        }
        return new Event(eventEntity.getAuthor(), eventEntity.getIpAddress(), new DateTime(eventEntity.getEventTime()), eventEntity.getCategory(), eventEntity.getSummary(), eventEntity.getObject(), eventDetails);
    }
}

