/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.enhancera.auditor.common.RequestType;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.util.JsonProxy;
import com.enhancera.auditor.common.util.Objects;
import com.enhancera.auditor.common.util.RequestBody;
import com.google.common.collect.ListMultimap;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class RequestData {
    private User author;
    private String ipAddress;
    private DateTime time;
    private String method;
    private String url;
    private RequestType type;
    @Nullable
    private ListMultimap<String, String> requestParameters;
    @Nullable
    private ListMultimap<String, String> requestHeaders;
    @Nullable
    private JsonProxy jsonBody;
    @Nullable
    private RequestBody body;

    public RequestData(User author, String ipAddress, DateTime time, String method, String url, ListMultimap<String, String> requestParameters) {
        this(author, ipAddress, time, method, url, requestParameters, null, null, null);
    }

    public RequestData(User author, String ipAddress, DateTime time, String method, String url, ListMultimap<String, String> requestParameters, ListMultimap<String, String> requestHeaders) {
        this(author, ipAddress, time, method, url, requestParameters, requestHeaders, null, null, RequestType.WEB);
    }

    public RequestData(User author, String ipAddress, DateTime time, String method, String url, ListMultimap<String, String> requestParameters, JsonProxy jsonBody, RequestBody body) {
        this(author, ipAddress, time, method, url, requestParameters, null, jsonBody, body);
    }

    public RequestData(User author, String ipAddress, DateTime time, String method, String url, ListMultimap<String, String> requestParameters, ListMultimap<String, String> requestHeaders, JsonProxy jsonBody, RequestBody body) {
        this(author, ipAddress, time, method, url, requestParameters, requestHeaders, jsonBody, body, RequestType.WEB);
    }

    public RequestData(User author, String ipAddress, DateTime time, String method, String url, ListMultimap<String, String> requestParameters, ListMultimap<String, String> requestHeaders, JsonProxy jsonBody, RequestBody body, RequestType type) {
        this.author = author;
        this.ipAddress = ipAddress;
        this.time = time;
        this.method = method;
        this.url = url;
        this.type = type;
        this.requestParameters = requestParameters;
        this.requestHeaders = requestHeaders;
        this.jsonBody = jsonBody;
        this.body = body;
    }

    public User getAuthor() {
        return this.author;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public DateTime getTime() {
        return this.time;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public RequestType getType() {
        return this.type;
    }

    public ListMultimap<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public ListMultimap<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public JsonProxy getJsonBody() {
        return this.jsonBody;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("author", this.author).add("ipAddress", this.ipAddress).add("time", this.time).add("method", this.method).add("url", this.url).add("type", (Object)this.type).add("requestParameters", this.requestParameters).add("requestHeaders", this.requestHeaders).add("jsonBody", this.jsonBody).add("body", this.body).toString();
    }
}

