/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.enhancera.auditor.common.ObjectManager;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

public class GenericObjectManager<T>
implements ObjectManager<T> {
    private static final FormattingLogger log = FormattingLogger.getLogger(GenericObjectManager.class);
    private final Map<String, T> objectsByName;
    private final T defaultObject;

    @SafeVarargs
    public GenericObjectManager(T defaultObject, T ... objects) {
        this.defaultObject = Preconditions.checkNotNull(defaultObject);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (T object : objects) {
            mapBuilder.put((Object)object.getClass().getSimpleName(), object);
        }
        this.objectsByName = mapBuilder.build();
        log.debug("Initialized objects: %s", this.objectsByName.keySet());
    }

    @Override
    public T getByName(@Nullable String objectName) {
        T object = Strings.isNullOrEmpty((String)objectName) ? this.defaultObject : this.objectsByName.get(objectName);
        Preconditions.checkNotNull(object, (String)"Object '%s' not found!", (Object[])new Object[]{objectName});
        return object;
    }
}

