(function($){
    $(function () {

        function isReadOnlyModeEnabled() {
            return AJS.Meta.get('access-mode') === 'READ_ONLY';
        }

        if(isReadOnlyModeEnabled()){
            $("#save-setting-button").hide();
            $("#cancel-setting-button").hide();

            $("#google-api-key").attr("disabled", true);
            $("#google-client-id").attr("disabled", true);
        }

        $("#save-setting-button").click(function (e) {

            var googleApiKey = $("#google-api-key").val();
            var googleClientId = $("#google-client-id").val();

            $.ajax({
                cache: false,
                data: {
                    apiKey : googleApiKey,
                    clientId: googleClientId
                },
                dataType: "json",
                type: "PUT",
                error: function(jqXHR, textStatus, errorThrown) {
                    window.location.reload();
                },
                success: function(data) {
                    $("#setting-message").show().fadeOut(2000);
                },
                timeout: 36000,
                url: Confluence.getContextPath() + "/rest/google-drive-connector-services/1.0/google-drive-connector/drive-settings"

            });
        });

        $("#cancel-setting-button").click(function (e) {
            e.preventDefault();
            window.location.reload();
        });
    });
}(AJS.$));