"use strict";

(function($){
    $(function () {
        function createCustomMacroDialog(e, baseUrl) {
            window.phamMemTinhTe = {
                googleDrive: {},
                baseUrl: baseUrl
            };

            var googleDriveDialog = createGoogleDriveDialog(e, baseUrl);
            var googleDriveDialogElement = googleDriveDialog.$el;

            var driveSaveButton = "#google-drive-save";

            googleDriveDialogElement.find(driveSaveButton).attr("disabled", true);

            e.params && (window.phamMemTinhTe.googleDrive = $.extend({}, e.params),
                googleDriveDialogElement.find(driveSaveButton).attr("disabled", false));

            googleDriveDialogElement.find(driveSaveButton).click(function() {

                var iframeDocument = $("#google-drive").get(0).contentWindow.document,
                    width = $("#width", iframeDocument).val(),
                    height = $("#height", iframeDocument).val(),
                    macroParams = $.extend({}, window.phamMemTinhTe.googleDrive, {
                        width: width ? width : "100%",
                        height: height ? height : "500px"
                    });

                    tinymce.confluence.macrobrowser.macroBrowserComplete({
                        name: "google-drive",
                        params: macroParams
                    });

                    googleDriveDialog.hide();

            }),
            googleDriveDialogElement.find("#google-drive-cancel").click(function() {
                return googleDriveDialog.hide()
            });

            return googleDriveDialog;
        }

        function createGoogleDriveDialog(macroEvent, baseUrl) {

            var dialog = aui.dialog.dialog2({
                id: "google-drive-dialog",
                size: "xlarge",
                titleText: "Google Drive Connector",
                content: Confluence.GoogleDrive.Templates.googleMacroDialogContent({baseUrl: baseUrl}),
                footerActionContent: Confluence.GoogleDrive.Templates.googleMacroDialogFooterActionContent(),
                modal: false
            });

            var dialogElement = $(dialog).appendTo($("body")).css("top", "90px");
            $(".aui-dialog2-content", dialogElement).css("padding-top", "5px");

            var driveParams = $.extend({
                width: "100%",
                height: "500px",
                fileName: "(none)"
            }, macroEvent.params);

            var  iframeDocument = $("#google-drive").get(0).contentWindow.document;

            iframeDocument.open();
            iframeDocument.write(Confluence.GoogleDrive.Templates.googlePicker({
                baseUrl: baseUrl,
                driveParams: driveParams
            }));
            iframeDocument.close();

            return AJS.dialog2(dialogElement).on("hide", function(e) {
                tinymce.confluence.macrobrowser.macroBrowserCancel();
                $(e.target).remove();
            })
        }

        AJS.MacroBrowser.setMacroJsOverride("google-drive", {
            opener: function(e) {
                var baseUrl = AJS.Confluence.getBaseUrl();
                createCustomMacroDialog(e, baseUrl).show();
            }
        });

    });
}(AJS.$));