/*
 * Decompiled with CFR 0.152.
 */
package com.elitesoft.google.drive.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.elitesoft.google.drive.activeobjects.DriveSetting;
import com.elitesoft.google.drive.model.DriveSettingModel;
import com.elitesoft.google.drive.services.ISettingService;
import com.google.common.base.Preconditions;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingService
implements ISettingService {
    private static final Logger LOG = LoggerFactory.getLogger(SettingService.class);
    private static final String PLUGIN_STORAGE_KEY = "com.elitesoftsp.confluence.google.drive.plugins";
    private final ActiveObjects ao;
    private final PluginSettingsFactory pluginSettingsFactory;

    public SettingService(ActiveObjects ao, PluginSettingsFactory pluginSettingsFactory) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public DriveSettingModel getDriveSetting() {
        DriveSettingModel pageSettingModel = new DriveSettingModel();
        try {
            DriveSetting[] settingEntities = (DriveSetting[])this.ao.find(DriveSetting.class);
            if (settingEntities != null && settingEntities.length > 0) {
                pageSettingModel = new DriveSettingModel(settingEntities[0].getID(), settingEntities[0].getGoogleApiKey(), settingEntities[0].getGoogleClientId());
            } else {
                this.addPageSetting(pageSettingModel);
            }
        }
        catch (Exception ex) {
            LOG.error("Cannot get page setting", (Throwable)ex);
        }
        return pageSettingModel;
    }

    public DriveSettingModel addPageSetting(DriveSettingModel setting) {
        setting.setId(1);
        try {
            DriveSetting settingEntity = (DriveSetting)this.ao.create(DriveSetting.class, new DBParam[]{new DBParam("ID", (Object)setting.getId())});
            settingEntity.setGoogleApiKey(setting.getGoogleApiKey());
            settingEntity.setGoogleClientId(setting.getGoogleClientId());
            settingEntity.save();
        }
        catch (Exception ex) {
            LOG.error("Cannot save page setting", (Throwable)ex);
        }
        return setting;
    }

    @Override
    public DriveSettingModel updateDriveSetting(DriveSettingModel setting) {
        try {
            DriveSetting[] settingEntities = (DriveSetting[])this.ao.find(DriveSetting.class);
            if (settingEntities != null && settingEntities.length > 0) {
                settingEntities[0].setGoogleApiKey(setting.getGoogleApiKey());
                settingEntities[0].setGoogleClientId(setting.getGoogleClientId());
                settingEntities[0].save();
            } else {
                this.addPageSetting(setting);
            }
        }
        catch (Exception ex) {
            LOG.error("Cannot update page setting", (Throwable)ex);
        }
        return setting;
    }
}

