/*
 * Decompiled with CFR 0.152.
 */
package com.elitesoft.google.drive.macros;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.elitesoft.google.drive.model.DriveSettingModel;
import com.elitesoft.google.drive.services.ISettingService;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/google-drive-connector")
public class DriveMacroResource {
    private static final Logger LOG = LoggerFactory.getLogger(DriveMacroResource.class);
    private static final String PLUGIN_STORAGE_KEY = "com.elitesoftsp.confluence.google.drive.plugins";
    private ISettingService settingService;
    private PermissionManager permissionManager;
    private PluginLicenseManager licenseManager;

    public DriveMacroResource(ISettingService settingService, PermissionManager permissionManager, PluginLicenseManager licenseManager) {
        this.settingService = settingService;
        this.permissionManager = permissionManager;
        this.licenseManager = licenseManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="settings")
    @Produces(value={"application/json"})
    public Response getGoogleAPIConfigure() {
        JSONObject thisObject = new JSONObject();
        try {
            String developerKey = "AIzaSyDlTsY5ZdWAEXobXFS85ZFgzJtkOuLeNCY";
            String clientId = "25537702508-mv2ehc6jo13sttok15edmhl3l4ha9slh.apps.googleusercontent.com";
            DriveSettingModel driveSettingModel = this.settingService.getDriveSetting();
            thisObject.put("developerKey", driveSettingModel.getGoogleApiKey());
            thisObject.put("clientId", driveSettingModel.getGoogleClientId());
            thisObject.put("valid", this.isValidConfiguration());
        }
        catch (JSONException e) {
            LOG.error("Unable to create a JSON object based on this object", (Throwable)e);
        }
        return Response.ok((Object)thisObject.toString()).build();
    }

    @PUT
    @Path(value="drive-settings")
    @Produces(value={"application/json"})
    public Response updatePageViewSettings(@FormParam(value="apiKey") @DefaultValue(value="") String apiKey, @FormParam(value="clientId") @DefaultValue(value="") String clientId) {
        boolean success = true;
        try {
            if (this.isAdministrator()) {
                DriveSettingModel settingModel = new DriveSettingModel(1, apiKey, clientId);
                this.settingService.updateDriveSetting(settingModel);
            }
        }
        catch (Exception ex) {
            success = false;
            LOG.error("Fail to update drive setting", (Object)ex.getMessage());
        }
        JSONObject thisObject = new JSONObject();
        try {
            thisObject.put("success", success);
        }
        catch (JSONException e) {
            LOG.error("Unable to create a JSON object based on this object", (Throwable)e);
        }
        return Response.ok((Object)thisObject.toString()).build();
    }

    private boolean isAdministrator() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.isConfluenceAdministrator((User)confluenceUser);
    }

    private boolean isValidConfiguration() {
        boolean isValid = false;
        try {
            PluginLicense pluginLicense;
            if (this.licenseManager.getLicense().isDefined() && !(pluginLicense = (PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined()) {
                isValid = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isValid;
    }
}

