
(function($){
    $(function () {


        "use strict";

        function isEmptyOrSpaces(str){
            return str === null || str.match(/^ *$/) !== null;
        }

        function getFileIdFromUrl(fileUrl) {

            if(fileUrl == ""){
                return "";
            }

            var parser = document.createElement('a');
            parser.href = fileUrl;

            var fileId = "";
            var pathnames = parser.pathname.split("/");

            for(var i = 0; i < pathnames.length; i ++ ){
                if(pathnames[i].length > fileId.length){
                    fileId = pathnames[i];
                }
            }

            //process for url type: https://drive.google.com/open?id=0BwFYb6USf4jgSldTTkJMc2duUGM
            var queryString = parser.search;
            if(queryString.length > 0){
                queryString = queryString.substring(1);

                var params = queryString.split("&");
                for(var i = 0; i < params.length; i ++){
                    var paramItems = params[i].split("=");
                    if(paramItems.length == 2 && paramItems[0].toLowerCase() == "id"){
                        if(paramItems[1].length > fileId.length){
                            fileId = paramItems[1];
                            break;
                        }
                    }
                }
            }

            return fileId;
        }

        function f(e) {

            var signInMessage = '<div class="aui-message aui-message-warning sign-in-message "><p><strong>Please sign in to your Google Account.</strong></p><p>You have to sign in to view Google Drive file or folder.</p><p><button class="aui-button aui-button-primary team-drive-sign-in-google">Sign In</button></p></div>';

            $(e).append(signInMessage);

            $(e).find(".team-drive-sign-in-google").click(function(e) {
                return gapi.auth2.getAuthInstance().signIn()
            })
        }

        function o(e) {
            /*gapi.auth2.getAuthInstance() ? i() : gapi.auth2.init({
                client_id: e,
                scope: scope
            }).then(function() {
                i()
            });*/

            //i();
        }

        function displayViewer() {
            //gapi.auth2.getAuthInstance().isSignedIn.listen(l);
            //l(gapi.auth2.getAuthInstance().isSignedIn.get());
            //gapi.auth2.getAuthInstance().currentUser.listen(p);

            $(".google-drive").each(function(e, t) {

                var tinhteMacroData = $(t).data();
                hienThongTinDocument(t, tinhteMacroData);

            });


            // For TEAM DRIVE
            /*$(".google-team-drive").each(function(e, t) {
                var teamDriveConfig = $(t).data();

                if(isEmptyOrSpaces(teamDriveConfig.url)){
                    var embeddedHTML = '<div class="aui-message aui-message-warning"><p>Please input Google Team Drive file or folder Url.</p></div>';
                    $(t).html(embeddedHTML);
                }
                else {

                    try {
                        var accessToken = gapi.auth2.getAuthInstance().currentUser.get().getAuthResponse().access_token;
                        var fileId = getFileIdFromUrl(teamDriveConfig.url);

                        $.ajax({
                            cache: false,
                            data: {"supportsTeamDrives": true},
                            headers: {
                                'Authorization': 'Bearer ' + accessToken
                            },
                            dataType: "json",
                            error: function (XMLHttpRequest, textStatus, errorThrown) {

                                var errorMessage = 'Google file or folder not found.';

                                try{
                                    var loggedInUser = gapi.auth2.getAuthInstance().currentUser.get().getBasicProfile().getEmail()
                                    errorMessage += '<br/>You are signed in as <strong>' + loggedInUser + '</strong>.';
                                }
                                catch (err){}
                                var embeddedHTML = '<div class="aui-message aui-message-warning"><p>' + errorMessage + '</p></div>';

                                $(t).html(embeddedHTML);
                            },
                            success: function (data) {

                                var tinhteMacroData = {
                                    url: data.embedLink,
                                    width: teamDriveConfig.width,
                                    height: teamDriveConfig.height,
                                    iconUrl: data.iconLink,
                                    filename: data.title,
                                    editUrl: data.alternateLink,
                                    fileId: data.id,
                                    mimeType: data.mimeType
                                };

                                hienThongTinDocument(t, tinhteMacroData);

                            },
                            type: "GET",
                            timeout: 36000,
                            url: "https://www.googleapis.com/drive/v2/files/" + fileId
                        });
                    }catch(err){}
                }

            });*/

        }

        function hienThongTinDocument(googleDriveElement , macroData) {

            var tinhteMacroData = macroData;
            var fileUrl = (tinhteMacroData.url, tinhteMacroData.embedUrl);
            var fileMimeType = tinhteMacroData.mimeType;
            var fileId = tinhteMacroData.fileId;
            var fileName = tinhteMacroData.filename;

            !fileUrl && kiemTraDungLaThuMuc(fileMimeType) && (tinhteMacroData.url = "https://drive.google.com/embeddedfolderview?id=" + fileId);

            $.extend(tinhteMacroData, kiemTraLoaiTapTin(fileMimeType));

            $(googleDriveElement).append(Confluence.GoogleDrive.Templates.googleViewer({data: tinhteMacroData}));
            var exportElement = $(googleDriveElement).find(".goolge-drive-export");
            var switchAccountElement = $(googleDriveElement).find(".switch-account");
            var exportFormats = layThongTinFormatCuaTapTin(fileId, fileMimeType);
            var firstExportFormat = exportFormats.shift();

            exportElement.click(function(event) {
                return window.open(firstExportFormat.downloadUrl);
            });

            AJS.$(exportElement).tooltip({
                title: function() {

                    if(firstExportFormat.format == "Unknown"){
                        return "Download " + fileName;
                    }

                    return "Download As " + firstExportFormat.format;
                }
            });

            if (exportFormats.length > 0) {
                var f = $(googleDriveElement).find(".goolge-drive-export-list");

                exportFormats.forEach(function(e) {
                    var t = $.extend({},e, {
                        filename: fileName
                    });

                    var downloadItem = '<li><a href="' + t.downloadUrl + '" target="_blank">Download As ' + t.format + '</a></li>';

                    f.append($(downloadItem));
                });

            } else {
                $(googleDriveElement).find(".goolge-drive-export-list-more").attr("disabled", true);
            }

            switchAccountElement.click(function() {

                getToken().then(resp => location.reload());
            });

            AJS.$(switchAccountElement).tooltip({
                title: function() {
                    return "Click here to switch google accounts. If you still see an empty viewer, you might need to sign out and sign in again."
                }
            });
        }

        function kiemTraDungLaThuMuc(mimeType) {
            return mimeType === "application/vnd.google-apps.folder";
        }

        function kiemTraLoaiTapTin(e) {
            if(e === "application/vnd.google-apps.folder"){
                return {
                    showButton: false
                };
            }

            return {
                showButton: true
            };
        }

        var loadGoogleDriveSetting = function() {
            return $.ajax({
                url: AJS.Confluence.getBaseUrl() + "/rest/google-drive-connector-services/1.0/google-drive-connector/settings",
                dataType: "json",
                type: "GET"
            });
        };


        function l(e) {
            var t = $(".sign-in-message").length > 0;
            e && t && p()
        }

        function p() {
            location.reload()
        }

        function d(e) {
            e.append('<div class="sign-in-message aui-message aui-message-warning">   <p class="title">        <strong>Please sign in to your Google Account.</strong>    </p>    <p>You have to sign in to view Google Drive document.</p>    <p><button class="aui-button aui-button-primary sign-in-google">Sign In</button></p></div>');

            e.find(".sign-in-google").click(function(e) {
                return gapi.auth2.getAuthInstance().signIn()
            });
        }


    function layThongTinFormatCuaTapTin(fileId, fileMimeType) {
        var moRongTapTin = {
            DOCX: "docx",
            PPTX: "pptx",
            XLSX: "xlsx",
            PDF: "pdf",
            TXT: "txt",
            ODT: "odt",
            RTF: "rtf",
            ZIP: "zip",
            EPUB: "epub",
            HTML: "html",
            ODS: "ods",
            CSV: "csv",
            TSV: "tsv",
            JPG: "jpeg",
            PNG: "png",
            SVG: "svg"
        };
        switch (fileMimeType) {
            case "application/vnd.google-apps.document":
                return [{
                    format: "Microsoft Word",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.DOCX)
                }
                , {
                    format: "PDF",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.PDF)
                }
                , {
                    format: "ODT",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.ODT)
                }, {
                    format: "EPUB",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.EPUB)
                }, {
                    format: "HTML",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.HTML)
                }, {
                    format: "Plain text",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.TXT)
                }, {
                    format: "Rich text",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.RTF)
                }, {
                    format: "ZIP",
                    downloadUrl: xuatKhauDocument(fileId, moRongTapTin.ZIP)
                }];

            case "application/vnd.google-apps.presentation":
                return [{
                    format: "Microsoft Powerpoint",
                    downloadUrl: xuatKhauTrinhDien(fileId, moRongTapTin.PPTX)
                }, {
                    format: "PDF",
                    downloadUrl: xuatKhauTrinhDien(fileId, moRongTapTin.PDF)
                }, {
                    format: "Plain text",
                    downloadUrl: xuatKhauTrinhDien(fileId, moRongTapTin.TXT)
                }];

            case "application/vnd.google-apps.spreadsheet":
                return [{
                    format: "Microsoft Excel",
                    downloadUrl: xuatKhauBangTinh(fileId, moRongTapTin.XLSX)
                }, {
                    format: "PDF",
                    downloadUrl: xuatKhauBangTinh(fileId, moRongTapTin.PDF)

                }, {
                    format: "ODS",
                    downloadUrl: xuatKhauBangTinh(fileId, moRongTapTin.ODS)
                }, {
                    format: "CSV",
                    downloadUrl: xuatKhauBangTinh(fileId, moRongTapTin.CSV)
                }, {
                    format: "TSV",
                    downloadUrl: xuatKhauBangTinh(fileId, moRongTapTin.TSV)
                }, {
                    format: "ZIP",
                    downloadUrl: xuatKhauBangTinh(fileId, moRongTapTin.ZIP)
                }];

            case "application/vnd.google-apps.form":
                return [{
                    format: "CSV",
                    downloadUrl: xuatKhauBieuMau(fileId)
                }];

            case "application/vnd.google-apps.drawing":
                return [{
                    format: "PNG",
                    downloadUrl: xuatKhauHinhAnh(fileId, moRongTapTin.PNG)
                }, {
                    format: "JPEG",
                    downloadUrl: xuatKhauHinhAnh(fileId, moRongTapTin.JPG)
                }, {
                    format: "SVG",
                    downloadUrl: xuatKhauHinhAnh(fileId, moRongTapTin.SVG)
                }, {
                    format: "PDF",
                    downloadUrl: xuatKhauHinhAnh(fileId, moRongTapTin.PDF)
                }];

            case "application/vnd.google-apps.drive-sdk.796396377186":
            case "application/vnd.google-apps.map":
                return [{
                    format: "Unknown", //Map
                    downloadUrl: xuatKhauBanDo(fileId)
                }];
            default:
                return [{
                    format: "Unknown",
                    downloadUrl: xuatKhauMacDinh(fileId)
                }]
        }
    }

    function xuatKhauDocument(e, t) {
        return "https://docs.google.com/document/export?format=" + t + "&id=" + e
    }

    function xuatKhauBangTinh(e, t) {
        return "https://docs.google.com/spreadsheets/export?format=" + t + "&id=" + e
    }

    function xuatKhauTrinhDien(e, t) {
        return "https://docs.google.com/presentation/export/" + t + "?id=" + e
    }

    function xuatKhauHinhAnh(e, t) {
        return "https://docs.google.com/drawings/export/" + t + "?id=" + e
    }

    function xuatKhauBieuMau(e) {

        var tz_offset = 0;

        try {
            var d = new Date();
            var n = d.getTimezoneOffset();
            tz_offset = Math.abs(n) * 60 * 1000;

        }catch (err){

        }

        return "https://docs.google.com/forms/d/" + e + "/downloadresponses?tz_offset=" + tz_offset;
    }

    function xuatKhauBanDo(e) {
        return "https://www.google.com/maps/d/kml?mid=" + e
    }

    // export default for unknown file
    function xuatKhauMacDinh(e) {
        return "https://docs.google.com/uc?authuser=0&id=" + e + "&export=download";
    }


    function noGoogleDriveConfiguration() {

        var message = '<div class="aui-message aui-message-warning"><p>Your Google Drive Connector is not configured correctly.</p></div>';

        $(".google-team-drive").each(function(e, t) {
            return $(t).append(message);
        });

        $(".google-drive").each(function(e, t) {
            return $(t).append(message);
        });
    }

    function showInvalidLicenseMessage() {

        var invalidLicenseMessage = '<div class="aui-message aui-message-warning"><p>Google Drive Connector requires a valid licence. Please ask your administrator(s) to create or update a licence.</p></div>';

        $(".google-team-drive").each(function(e, t) {
            return $(t).append(invalidLicenseMessage);
        });

        $(".google-drive").each(function(e, t) {
            return $(t).append(invalidLicenseMessage);
        });

    }

    var googleAPILib = "https://apis.google.com/js/api.js";
    var scope = "https://www.googleapis.com/auth/drive";

    var tokenClient;
    var access_token;

    AJS.toInit(function() {
        loadGoogleDriveSetting().then(function(e) {
            var t = e.clientId;
            var valid = e.valid;

            if(t == ""){
                noGoogleDriveConfiguration();
            }
            else if(valid == false) {
                showInvalidLicenseMessage();
            }
            else {

                displayViewer();

                $.getScript("https://accounts.google.com/gsi/client").done(function () {

                    tokenClient = google.accounts.oauth2.initTokenClient({
                        client_id: t,
                        scope: 'https://www.googleapis.com/auth/drive',
                        callback: (tokenResponse) => {
                            access_token = tokenResponse.access_token;
                        },
                    });

                });
            };
        })
    });

    async function getToken() {
        await new Promise((resolve, reject) => {
              try {
                // Settle this promise in the response callback for requestAccessToken()
                tokenClient.callback = (resp) => {
                  if (resp.error !== undefined) {
                    reject(resp);
                  }
                  // GIS has automatically updated gapi.client with the newly issued access token.
                  //console.log('gapi.client access token: ' + JSON.stringify(gapi.client.getToken()));
                  access_token = resp.access_token;
                  resolve(resp);
                };
                tokenClient.requestAccessToken();
              } catch (err) {
                console.log(err)
              }
        });
    }

    });
}(AJS.$));