
    var tokenClient;
    var access_token;

    function gapiStart() {
        gapi.client.init({
      }).then(function() {
        gapi.load('picker', '1');
      }).then(function(response) {
        //console.log('discovery document loaded');
      }, function(reason) {
        console.log('Error: ' + reason.result.error.message);
      });
    }

    function gapiLoad() {
      gapi.load('client', gapiStart)
    }

    function gisInit() {

        loadGoogleDriveSetting().then(function(t) {
            if(t.clientId === ""){
                var message = '<div id="no-google-config" class="aui-message aui-message-warning"><p>Your Google Drive Connector is not configured correctly.</p></div>';

                $("#google-drive-file-preview").html(message);
            }
            else {

            console.log("Hello");

                tokenClient = google.accounts.oauth2.initTokenClient({
                    client_id: t.clientId,
                    scope: 'https://www.googleapis.com/auth/drive',
                    callback: (tokenResponse) => {
                        access_token = tokenResponse.access_token;
                        console.log(access_token);
                    },
                });

            }
        });

    }

    /*function getToken() {
      tokenClient.requestAccessToken();
    }*/

    function revokeToken() {
      google.accounts.oauth2.revoke(access_token, () => {console.log('access token revoked')});
    }

    async function getToken() {
        await new Promise((resolve, reject) => {
              try {
                // Settle this promise in the response callback for requestAccessToken()
                tokenClient.callback = (resp) => {
                  if (resp.error !== undefined) {
                    reject(resp);
                  }
                  // GIS has automatically updated gapi.client with the newly issued access token.
                  //console.log('gapi.client access token: ' + JSON.stringify(gapi.client.getToken()));
                  access_token = resp.access_token;
                  resolve(resp);
                };
                tokenClient.requestAccessToken();
              } catch (err) {
                console.log(err)
              }
        });
    }


    function showPicker() {
        if(access_token){
            createPicker();
        }
        else{
            getToken().then(resp => createPicker());
        }
    }

    function createPicker() {

        var folder = new google.picker.DocsView(google.picker.ViewId.FOLDERS)
                            .setSelectFolderEnabled(true);

        var teamFolder = new google.picker.DocsView(google.picker.ViewId.DOCS)
                .setEnableTeamDrives(true)
                .setIncludeFolders(true)
                .setSelectFolderEnabled(true);

        var myFolder = new google.picker.DocsView(google.picker.ViewId.DOCS)
                .setOwnedByMe(true)
                .setIncludeFolders(true)
                .setSelectFolderEnabled(true);

        var developerKey = '';
        var picker = (new google.picker.PickerBuilder)
                .enableFeature(google.picker.Feature.SUPPORT_TEAM_DRIVES)
                .addView(google.picker.ViewId.DOCS)
                .addView(folder)
                .addView(teamFolder)
                .addView(myFolder)
                .addView(new google.picker.DocsUploadView)
                .setOAuthToken(access_token)
                .setDeveloperKey(developerKey)
                .setCallback(pickerCallback)
                .setSize(700, 400)
                .hideTitleBar()
                .build();

        picker.setVisible(true);
    }

    function pickerCallback(t) {
        if (t[google.picker.Response.ACTION] === google.picker.Action.PICKED) {

            var e = t[google.picker.Response.DOCUMENTS][0];

            fileUrl = e[google.picker.Document.EMBEDDABLE_URL],
            fileName = e[google.picker.Document.NAME],
            fileEmbedUrl = e[google.picker.Document.EMBEDDABLE_URL],
            fileIconUrl = e[google.picker.Document.ICON_URL],
            fileEditUrl = e[google.picker.Document.URL],
            fileId = e[google.picker.Document.ID],
            fileMimeType = e[google.picker.Document.MIME_TYPE];

            window.parent.phamMemTinhTe.googleDrive = {
                url: fileUrl,
                fileName: fileName,
                editUrl: fileEditUrl,
                embedUrl: fileEmbedUrl,
                iconUrl: fileIconUrl,
                fileId: fileId,
                mimeType: fileMimeType
            };

            showSelectItem();
        }
    }

    function showSelectItem() {

        $("#fileName").val(fileName);
        $("#embedUrl").val(fileEmbedUrl),
        $("#file-icon-url").html('<img src="' + fileIconUrl + '" alt="File Icon"/>');
        $("#google-drive-save", window.parent.document).attr("disabled", false);

        updatePreviewPanel();
    }

    var fileUrl = '',
        fileName = $("#fileName").val(),
        fileIconUrl = '',
        fileMimeType = '',
        fileEmbedUrl = $("#embedUrl").val(),
        fileEditUrl = $("#editUrl").val(),
        fileId = $("#fileId").val();

    function updatePreviewPanel() {
        if(fileEmbedUrl) {

            var loadingMessage = '<div id="google-drive-message" class="aui-message aui-message-success" style="margin-top: 20px;"><p><span class="aui-icon aui-icon-wait">Loading...</span><strong> ' +
             fileName + " </strong> selected.</p></div>";

            var previewIframe = '<iframe src="' + fileEmbedUrl + '" class="google-drive-file-preview-frame" id="google-drive-file-preview-frame-id" />';

            $("#google-drive-file-preview").html(loadingMessage + previewIframe);

            setTimeout(function(){ $("#google-drive-message").hide(); }, 2000);

        }
        else {
            var previewImage = '<img src ="' + baseUrl + "/" + resourcePath + '/images/google-drive-icon.png" class= "google-drive-preview-logo" alt = "Google Drive"/>';
            $("#google-drive-file-preview").html(previewImage);
        }
    }

    var loadGoogleDriveSetting = function() {

        baseUrl = window.parent.phamMemTinhTe.baseUrl;
        return $.ajax({
            url: baseUrl + "/rest/google-drive-connector-services/1.0/google-drive-connector/settings",
            dataType: "json",
            type: "GET"
        });
    };

    $("#browse-picker").click(showPicker);

    $(function() {
        updatePreviewPanel();
    });
