/*
 * Decompiled with CFR 0.152.
 */
package com.elitesoft.google.drive.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.elitesoft.google.drive.model.DriveSettingModel;
import com.elitesoft.google.drive.services.ISettingService;
import org.apache.log4j.Logger;

public class GoogleDriveSettingAction
extends ConfluenceActionSupport {
    private static final Logger logger = Logger.getLogger(GoogleDriveSettingAction.class);
    private static final String PLUGIN_STORAGE_KEY = "com.elitesoftsp.confluence.google.drive.plugins";
    private SettingsManager settingsManager;
    private PermissionManager permissionManager;
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginLicenseManager pluginLicenseManager;
    private ISettingService settingService;
    private boolean isSystemAdmin;
    private boolean isValidLicence;
    private String apiKey;
    private String clientId;

    public String getBaseUrl() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void setSettingService(ISettingService settingService) {
        this.settingService = settingService;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public boolean getIsSystemAdmin() {
        return this.isSystemAdmin;
    }

    public boolean getValidLicence() {
        return this.isValidLicence;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUpmUrl() {
        try {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + "/plugins/servlet/upm#manage";
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String doDefault() throws Exception {
        return "input";
    }

    public String execute() throws Exception {
        this.isValidLicence = this.isValidLicense();
        this.isSystemAdmin = this.isSystemAdmin();
        DriveSettingModel settingModel = this.settingService.getDriveSetting();
        this.apiKey = settingModel.getGoogleApiKey();
        this.clientId = settingModel.getGoogleClientId();
        return "success";
    }

    private boolean isValidLicense() {
        String baseURL = this.getBaseUrl();
        boolean isValid = false;
        try {
            PluginLicense pluginLicense;
            if (baseURL.contains("localhost:8080/confluence")) {
                isValid = true;
            } else if (this.pluginLicenseManager.getLicense().isDefined() && !(pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                isValid = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isValid;
    }

    private boolean isSystemAdmin() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.isConfluenceAdministrator((User)confluenceUser);
    }
}

