


    const gapiLoadPromise = new Promise((resolve, reject) => {
      gapiLoadOkay = resolve;
      gapiLoadFail = reject;
    });
    const gisLoadPromise = new Promise((resolve, reject) => {
      gisLoadOkay = resolve;
      gisLoadFail = reject;
    });

    var tokenClient;

    (async () => {
      document.getElementById("showEventsBtn").style.visibility="hidden";
      document.getElementById("revokeBtn").style.visibility="hidden";

      // First, load and initialize the gapi.client
      await gapiLoadPromise;
      await new Promise((resolve, reject) => {
        // NOTE: the 'auth2' module is no longer loaded.
        gapi.load('client', {callback: resolve, onerror: reject});
      });
      await gapi.client.init({
        // NOTE: OAuth2 'scope' and 'client_id' parameters have moved to initTokenClient().
      })
      .then(function() {  // Load the Calendar API discovery document.
        //gapi.client.load('calendar', 'v3');

        gapi.load('picker', '1');

      });

      // Now load the GIS client
      await gisLoadPromise;
        await new Promise((resolve, reject) => {
          try {
            tokenClient = google.accounts.oauth2.initTokenClient({
                client_id: '376195512481-hqpliv295qk8sdprg9ab2sg4np12da3j.apps.googleusercontent.com',
                scope: 'https://www.googleapis.com/auth/drive',
                //prompt: 'consent',
                callback: '',  // defined at request time in await/promise scope.
            });
            resolve();
          } catch (err) {
            reject(err);
          }
        });

      document.getElementById("showEventsBtn").style.visibility="visible";
      document.getElementById("revokeBtn").style.visibility="visible";
    })();

    async function getToken(err) {

      /*if (err.result.error.code == 401 || (err.result.error.code == 403) &&
          (err.result.error.status == "PERMISSION_DENIED")) {*/

        // The access token is missing, invalid, or expired, prompt for user consent to obtain one.
        await new Promise((resolve, reject) => {
          try {
            // Settle this promise in the response callback for requestAccessToken()
            tokenClient.callback = (resp) => {
              if (resp.error !== undefined) {
                reject(resp);
              }
              // GIS has automatically updated gapi.client with the newly issued access token.
              console.log('gapi.client access token: ' + JSON.stringify(gapi.client.getToken()));
              resolve(resp);
            };
            tokenClient.requestAccessToken();
          } catch (err) {
            console.log(err)
          }
        });
      /*} else {
        // Errors unrelated to authorization: server errors, exceeding quota, bad requests, and so on.
        throw new Error(err);
      }*/
    }

    function showEvents() {

      // Try to fetch a list of Calendar events. If a valid access token is needed,
      // prompt to obtain one and then retry the original request.
      /*gapi.client.calendar.events.list({ 'calendarId': 'primary' })
      .then(calendarAPIResponse => console.log(JSON.stringify(calendarAPIResponse)))
      .catch(err  => getToken(err))  // for authorization errors obtain an access token
      .then(retry => gapi.client.calendar.events.list({ 'calendarId': 'primary' }))
      .then(calendarAPIResponse => console.log(JSON.stringify(calendarAPIResponse)))
      .catch(err  => console.log(err));   // cancelled by user, timeout, etc.*/

       getToken().then(retry => createPicker());


    }

    function revokeToken() {
      let cred = gapi.client.getToken();
      if (cred !== null) {
        google.accounts.oauth2.revoke(cred.access_token, () => {console.log('Revoked: ' + cred.access_token)});
        gapi.client.setToken('');
      }
    }


    function createPicker() {
        var access_token = gapi.client.getToken().access_token; //gapi.auth2.getAuthInstance().currentUser.get().getAuthResponse().access_token;
        if (access_token) {
            var folder = new google.picker.DocsView(google.picker.ViewId.FOLDERS)
                    .setSelectFolderEnabled(true);

            var teamFolder = new google.picker.DocsView(google.picker.ViewId.DOCS)
                    .setEnableTeamDrives(true)
                    .setIncludeFolders(true)
                    .setSelectFolderEnabled(true);

            var myFolder = new google.picker.DocsView(google.picker.ViewId.DOCS)
                    .setOwnedByMe(true)
                    .setIncludeFolders(true)
                    .setSelectFolderEnabled(true);

            var developerKey = '';
            var picker = (new google.picker.PickerBuilder)
                    .enableFeature(google.picker.Feature.SUPPORT_TEAM_DRIVES)
                    .addView(google.picker.ViewId.DOCS)
                    .addView(folder)
                    .addView(teamFolder)
                    .addView(myFolder)
                    .addView(new google.picker.DocsUploadView)
                    .setOAuthToken(access_token)
                    .setDeveloperKey(developerKey)
                    .setCallback(pickerCallback)
                    .setSize(700, 400)
                    .hideTitleBar()
                    .build();

            picker.setVisible(true);
        }
    }

    function pickerCallback(t) {
        if (t[google.picker.Response.ACTION] === google.picker.Action.PICKED) {

            var e = t[google.picker.Response.DOCUMENTS][0];

            fileUrl = e[google.picker.Document.EMBEDDABLE_URL],
            fileName = e[google.picker.Document.NAME],
            fileEmbedUrl = e[google.picker.Document.EMBEDDABLE_URL],
            fileIconUrl = e[google.picker.Document.ICON_URL],
            fileEditUrl = e[google.picker.Document.URL],
            fileId = e[google.picker.Document.ID],
            fileMimeType = e[google.picker.Document.MIME_TYPE];

            window.parent.phamMemTinhTe.googleDrive = {
                url: fileUrl,
                fileName: fileName,
                editUrl: fileEditUrl,
                embedUrl: fileEmbedUrl,
                iconUrl: fileIconUrl,
                fileId: fileId,
                mimeType: fileMimeType
            };

            showSelectItem();
        }
    }

    function showSelectItem() {

        $("#fileName").val(fileName);
        $("#embedUrl").val(fileEmbedUrl),
        $("#file-icon-url").html('<img src="' + fileIconUrl + '" alt="File Icon"/>');
        $("#google-drive-save", window.parent.document).attr("disabled", false);

        updatePreviewPanel();
    }

    var fileUrl = '',
        fileName = $("#fileName").val(),
        fileIconUrl = '',
        fileMimeType = '',
        fileEmbedUrl = $("#embedUrl").val(),
        fileEditUrl = $("#editUrl").val(),
        fileId = $("#fileId").val();

    function updatePreviewPanel() {
        if(fileEmbedUrl) {

            var loadingMessage = '<div id="google-drive-message" class="aui-message aui-message-success" style="margin-top: 20px;"><p><span class="aui-icon aui-icon-wait">Loading...</span><strong> ' +
             fileName + " </strong> selected.</p></div>";

            var previewIframe = '<iframe src="' + fileEmbedUrl + '" class="google-drive-file-preview-frame" id="google-drive-file-preview-frame-id" />';

            $("#google-drive-file-preview").html(loadingMessage + previewIframe);

            setTimeout(function(){ $("#google-drive-message").hide(); }, 2000);

        }
        else {
            var previewImage = '<img src ="' + baseUrl + "/" + resourcePath + '/images/google-drive-icon.png" class= "google-drive-preview-logo" alt = "Google Drive"/>';
            $("#google-drive-file-preview").html(previewImage);
        }
    }

    var loadGoogleDriveSetting = function() {
        return $.ajax({
            url: baseUrl + "/rest/google-drive-connector-services/1.0/google-drive-connector/settings",
            dataType: "json",
            type: "GET"
        });
    };

    function initializePicker() {
        loadGoogleDriveSetting().then(function(t) {

            if(t.clientId === ""){
                var message = '<div id="no-google-config" class="aui-message aui-message-warning"><p>Your Google Drive Connector is not configured correctly.</p></div>';

                $("#google-drive-file-preview").html(message);
            }
            else {

                if (gapiClientLoaded && gapi.auth2.getAuthInstance()) {
                    gapi.auth2.getAuthInstance().isSignedIn.get() && gapiPickerLoaded ? createPicker() : gapi.auth2.getAuthInstance().signIn();
                }
                else {
                    var e = function (k) {
                        k && createPicker()
                    };

                    gapi.auth2.init({
                        client_id: clientId = t.clientId,
                        scope: scope
                    }).then(function () {
                        gapi.auth2.getAuthInstance().isSignedIn.listen(e),
                            e(gapi.auth2.getAuthInstance().isSignedIn.get())
                    })
                }
            }
        });
    }

/*
"use strict";




var scope = "https://www.googleapis.com/auth/drive",
    baseUrl = window.parent.phamMemTinhTe.baseUrl,
    resourcePath = "download/resources/com.elitesoftsp.confluence.google.drive.plugins:google-drive-custom-resources",
    clientId = '', // client id
    developerKey = '';//API key

var fileUrl = '',
    fileName = $("#fileName").val(),
    fileIconUrl = '',
    fileMimeType = '',
    fileEmbedUrl = $("#embedUrl").val(),
    fileEditUrl = $("#editUrl").val(),
    fileId = $("#fileId").val();

var gapiClientLoaded = false,
    gapiPickerLoaded = false;


function loadGooglePickerLib() {
    gapi.load("client:auth2", function() {
        return gapiClientLoaded = true;
    }), gapi.load("picker", function() {
        return gapiPickerLoaded = true;
    });
}

function initializePicker() {
    loadGoogleDriveSetting().then(function(t) {

        if(t.clientId === ""){
            var message = '<div id="no-google-config" class="aui-message aui-message-warning"><p>Your Google Drive Connector is not configured correctly.</p></div>';

            $("#google-drive-file-preview").html(message);
        }
        else {

            if (gapiClientLoaded && gapi.auth2.getAuthInstance()) {
                gapi.auth2.getAuthInstance().isSignedIn.get() && gapiPickerLoaded ? createPicker() : gapi.auth2.getAuthInstance().signIn();
            }
            else {
                var e = function (k) {
                    k && createPicker()
                };

                gapi.auth2.init({
                    client_id: clientId = t.clientId,
                    scope: scope
                }).then(function () {
                    gapi.auth2.getAuthInstance().isSignedIn.listen(e),
                        e(gapi.auth2.getAuthInstance().isSignedIn.get())
                })
            }
        }
    });
}



function switchAccount() {
    gapi.auth2.getAuthInstance() ? (selectAccount(), gapi.auth2.getAuthInstance().currentUser.listen(updatePreviewPanel)) : loadGoogleDriveSetting().then(function(t) {
        clientId = t.clientId,
        gapi.auth2.init({
            client_id: clientId,
            scope: scope
        }).then(function() {
            selectAccount();
            gapi.auth2.getAuthInstance().currentUser.listen(updatePreviewPanel);
        })
    })
}

function selectAccount() {
    gapi.auth2.getAuthInstance().signIn({
        prompt: "select_account"
    });
}



var loadGoogleDriveSetting = function() {
    return $.ajax({
        url: baseUrl + "/rest/google-drive-connector-services/1.0/google-drive-connector/settings",
        dataType: "json",
        type: "GET"
    });
};

$(function() {
    loadGooglePickerLib();
    updatePreviewPanel();
});

$("#browse-picker").click(initializePicker);
$("#switch-account").click(switchAccount);

*/