// Legacy for confluence plugin v 1.0.1
// Get device id by name
function d42GetDeviceByName(name) {
	var options = d42OptionsAjaxCall("d42Options/getDeviceIdByName", {
		"name": name
	});
	if (options && options.length > 0 && options[0].id)
		return options[0].id;
	return "";
}

// Legacy for confluence plugin v 1.0.1
// Load value from previous version of plugin if it exists
function d42LoadSimpleLegacy(d42ValueObject) {
	var form = d42ValueObject.closest("form");
	var result = "";
	var objectId = form.find("#macro-param-objectId").val();
	if (objectId) {
		result = "D" + objectId;
	} else {
		var objectName = form.find("#macro-param-objectName").val();
		if (objectName) 
			result = "D" + d42GetDeviceByName(objectName);
	}
	form.find("#macro-param-objectType").val("");
	form.find("#macro-param-objectId").val("");
	form.find("#macro-param-objectName").val("");
	return result;
}
// Legacy for confluence plugin v 1.0.1
// Hide legacy values
function d42HideSimpleLegacy(d42ValueObject) {
	var form = d42ValueObject.closest("form");
	form.find("#macro-param-div-objectType").hide();
	form.find("#macro-param-div-objectId").hide();
	form.find("#macro-param-div-objectName").hide();
}

function d42LoadTableLegacy(d42TypeObject) {
	var form = d42TypeObject.closest("form");
	var result = "";
	var type = form.find("#macro-param-objectType");
	switch (type.val()) {
	case "Device":
		result = "D";
		break;
	case "Rack":
		result = "R";
		break;
	case "PDU":
		result = "U";
		break;
	case "Part":
		result = "P";
		break;
	}
	return result;
}

function d42HideTableLegacy(d42TypeObject) {
	var form = d42TypeObject.closest("form");
	form.find("#macro-param-div-objectType").hide();
	form.find("#macro-param-div-filterParam1").hide();
	form.find("#macro-param-div-filterParamValue1").hide();
	form.find("#macro-param-div-filterParam2").hide();
	form.find("#macro-param-div-filterParamValue2").hide();
}

function getSpaceId() {
	var spaceId = "0";
	AJS.$.ajax({
		url : AJS.contextPath() + "/rest/api/space/" + AJS.params.spaceKey,
		type : "get",
		dataType : "json",
		async : false,
		success : function(data) {
			spaceId = data.id;
		}
	});
	return spaceId;
}

function d42RenderSimpleMacro() {
	var d42ValueObject = AJS.$("#macro-param-d42Value");
	if (d42ValueObject && d42ValueObject.is(":visible")) {
		d42HideSimpleLegacy(d42ValueObject);
		var spaceId = getSpaceId();
		var prevValue;
		if(!d42ValueObject.val()) {
			prevValue = d42LoadSimpleLegacy(d42ValueObject);
		} else {
			prevValue = d42ValueObject.val();
		}
		d42RenderEdit(spaceId, "0", "#macro-param-d42Value", prevValue);
	}
}

function d42RefillTableTypes(firstLevelId, secondLevelId) {
	var options = d42OptionsAjaxCall("d42Options/types", {
		"firstLevelId" : firstLevelId,
		"secondLevelId" : secondLevelId,
		"spaceKey" : AJS.params.spaceKey
	});
	var typesSelect = AJS.$("select.d42-type-select");
	d42FillSelect(options, typesSelect, true);
	//select the first value to avoid empty selection
	typesSelect.find("option:first").prop('selected', true);
	typesSelect.change();
	return options;	
}

function d42RenderTableEdit(firstLevelId, secondLevelId, typeValue) {
	var filters = d42OptionsAjaxCall("d42Options/filters", {
		"firstLevelId" : firstLevelId
	});
// for confluence restrict spaces
    if (filters==null) {
		// Hide the modern REST-dependent elements
		var filterInput = AJS.$("#macro-param-d42SecondLevelId");
		var typesInput = AJS.$("#macro-param-d42Type");
		filterInput.hide();
		typesInput.hide();
		
		// Hide the modern Object Type section completely (including labels and descriptions)
		typesInput.closest("div[class*='field-group']").hide();
		AJS.$("#macro-param-div-d42Type").hide();
		// Also hide any labels/descriptions for the modern type field
		AJS.$("label[for='macro-param-d42Type']").hide();
		AJS.$("div:contains('Type of Device42 object')").filter(function() {
			return AJS.$(this).children().length === 0;
		}).hide();
		
		// Create legacy-style filter dropdown (no Select2)
		var selectFilter = AJS.$("<select>", {
			"class" : "d42-filter-select",
			name : "filter" + soy.$$escapeHtml(firstLevelId),
			id : "filter_" + soy.$$escapeHtml(firstLevelId),
			"first-id" : soy.$$escapeHtml(firstLevelId)
		});
		
		// Add predefined filter options (these work without REST)
		var predefinedFilters = [
			{ value: "0", text: "default" },
		];
		
		AJS.$.each(predefinedFilters, function(index, filter) {
			selectFilter.append(AJS.$("<option>", {
				value: filter.value,
				text: filter.text
			}));
		});
		
		// Insert the filter dropdown after the hidden input
		filterInput.after(selectFilter);
		
		// Set selected filter value if provided
		if (secondLevelId && secondLevelId !== "0") {
			selectFilter.val(secondLevelId);
		} else {
			selectFilter.val("0"); // Select "default"
		}
		
		// Show the legacy object type dropdown (this works without REST)
		var legacyObjectType = AJS.$("#macro-param-div-objectType");
		if (legacyObjectType.length > 0) {
			legacyObjectType.show();
		}
		
		// Hide the legacy filter parameter fields since we have proper filter dropdown now
		AJS.$("#macro-param-div-filterParam1").hide();
		AJS.$("#macro-param-div-filterParamValue1").hide();
		AJS.$("#macro-param-div-filterParam2").hide();
		AJS.$("#macro-param-div-filterParamValue2").hide();
		
		return;
    }
//----------------------------------
	var filterInput = AJS.$("#macro-param-d42SecondLevelId")
	var typesInput = AJS.$("#macro-param-d42Type");
	filterInput.hide();
	typesInput.hide();
	
	var selectFilter = AJS.$(
			"<select>",
			{
				"class" : "d42-filter-select trigger-select2 js-select2-picker",
				name : "filter" + soy.$$escapeHtml(firstLevelId),
				id : "filter_" + soy.$$escapeHtml(firstLevelId),
				"first-id" : soy.$$escapeHtml(firstLevelId)
			});
	var selectType = AJS.$(
			"<select>",
			{
				"class" : "d42-type-select trigger-select2 js-select2-picker",
				name : "type_" + soy.$$escapeHtml(firstLevelId),
				id : "type_" + soy.$$escapeHtml(firstLevelId),
				"first-id" : soy.$$escapeHtml(firstLevelId)
			});
	d42FillSelect(filters, selectFilter, false);
	filterInput.after(selectFilter);
	typesInput.after(selectType);
	
	// Use same Select2 initialization pattern as simple macros
	if (selectFilter.auiSelect2) {
		selectFilter.auiSelect2();
	} else {
		selectFilter.select2();
	}
	
	if (selectType.auiSelect2) {
		selectType.auiSelect2();
	} else {
		selectType.select2();
	}
	
	var selectOptions = selectFilter.find("option[value='" + soy.$$escapeHtml(secondLevelId) + "']");
	if (selectOptions.length > 0) {
		selectOptions.prop('selected', true);
	} else
		selectFilter.find("option:first").prop('selected', true);
	selectFilter.change();
	if(typeValue) {
		selectOptions = selectType.find("option[value='" + soy.$$escapeHtml(typeValue) + "']");
		selectOptions.prop('selected', true);
		selectOptions.change();
	}
}

function d42RenderTableMacro() {
	var d42TypeObject = AJS.$("#macro-param-d42Type");
	if (d42TypeObject && d42TypeObject.is(":visible")) {
		// Test if REST endpoints are working before hiding legacy elements
		var spaceId = getSpaceId();
		var testFilters = d42OptionsAjaxCall("d42Options/filters", {
			"firstLevelId" : spaceId
		});

		// Only hide legacy elements if REST endpoints are working
		if (testFilters !== null) {
			d42HideTableLegacy(d42TypeObject);
		} 

		var d42SecondLevelIdObject = AJS.$("#macro-param-d42SecondLevelId");
		var typeValue;
		if (!d42TypeObject.val()) {
			typeValue = d42LoadTableLegacy(d42TypeObject);
		} else {
			typeValue = d42TypeObject.val();
		}
		var secondLevelId = "0";
		if (d42SecondLevelIdObject.val())
			secondLevelId = d42SecondLevelIdObject.val();
			
		d42RenderTableEdit(spaceId, secondLevelId, typeValue);
	}
}

function d42RenderMacro() {
	d42RenderSimpleMacro();
	d42RenderTableMacro();
}

// Modern event handling for Confluence 9.2.4+
function d42InitializeMacroHandling() {
	// Try multiple approaches to trigger macro rendering
	
	// 1. Immediate execution
	setTimeout(function() {
		d42RenderMacro();
	}, 100);
	
	// 2. Mutation Observer for modern browsers
	if (typeof MutationObserver !== 'undefined') {
		var observer = new MutationObserver(function(mutations) {
			var shouldRender = false;
			mutations.forEach(function(mutation) {
				if (mutation.addedNodes && mutation.addedNodes.length > 0) {
					for (var i = 0; i < mutation.addedNodes.length; i++) {
						var node = mutation.addedNodes[i];
						if (node.nodeType === 1 && (
							(node.id && node.id.indexOf('macro-param') !== -1) ||
							(node.className && node.className.indexOf('macro') !== -1) ||
							(AJS.$(node).find('[id*="macro-param"]').length > 0)
						)) {
							shouldRender = true;
							break;
						}
					}
				}
			});
			
			if (shouldRender) {
				setTimeout(d42RenderMacro, 50);
			}
		});
		
		observer.observe(document.body, {
			childList: true,
			subtree: true
		});
	}
	
	// 3. Periodic checking as fallback
	var checkCount = 0;
	var periodicCheck = setInterval(function() {
		checkCount++;
		if (checkCount > 20) { // Stop after 10 seconds
			clearInterval(periodicCheck);
			return;
		}
		
		var macroElements = AJS.$('[id*="macro-param"]');
		if (macroElements.length > 0) {
			d42RenderMacro();
		}
	}, 500);
}

AJS.$(document).ready(function(event) {

	// Modern event delegation replacing deprecated .live() method
	AJS.$(document).on("change", "select.d42-data-field-type-select", function(event) {
		var firstLevelId = AJS.$(this).attr("first-id");
		var secondLevelId = AJS.$(this).attr("second-id");
		d42ResetDataSelection(firstLevelId, secondLevelId);
        d42ApplySelect2(firstLevelId,secondLevelId);
	});

	AJS.$(document).on("change", "input.d42-data-field-select", function(event) {
		d42StoreData(AJS.$(this).attr("first-id"), AJS.$(this)
				.attr("second-id"), "#macro-param-d42Value");
	});

	AJS.$(document).on("change", "select.d42-filter-select", function(event) {
		var firstLevelId = AJS.$(this).attr("first-id");
		var secondLevelId = AJS.$(this).find(":selected").attr("value");
		AJS.$("#macro-param-d42SecondLevelId").val(secondLevelId);
		d42RefillTableTypes(firstLevelId, secondLevelId);
	});
	
	AJS.$(document).on("change", "select.d42-type-select", function(event) {
		AJS.$("#macro-param-d42Type").val(AJS.$(this).find(":selected").attr("value"));
	});
	
	// Initialize modern macro handling
	d42InitializeMacroHandling();

});

// Modern event bindings for different Confluence versions
AJS.$(window).on("load", function() {
	setTimeout(d42RenderMacro, 1000);
});

// Global function for manual triggering
window.d42TriggerMacroRender = d42RenderMacro;