/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.manager;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D42ConfluenceRestrictFilter
implements Filter {
    public static final String D42_USER_NAME = "D42UserName";
    private static final Logger log = LoggerFactory.getLogger(D42ConfluenceRestrictFilter.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SpaceManager spaceManager;

    public D42ConfluenceRestrictFilter(PluginSettingsFactory pluginSettingsFactory, SpaceManager spaceManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.spaceManager = spaceManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            httpResponse.sendError(401, "Authentication required");
            return;
        }
        servletRequest.setAttribute(D42_USER_NAME, (Object)confluenceUser.getKey());
        String referer = httpRequest.getHeader("referer");
        String requestURI = httpRequest.getRequestURI();
        if (referer == null || referer.contains("/rest/") || requestURI.contains("/rest/")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        try {
            URL url = new URL(referer);
            String query = url.getQuery();
            if (query == null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String[] params = query.split("&");
            int pageId = 0;
            String spaceKey = null;
            for (String str : params) {
                if (str.contains("spaceKey")) {
                    spaceKey = str.split("=")[1];
                    break;
                }
                if (!str.contains("pageId") && !str.contains("draftId")) continue;
                pageId = Integer.parseInt(str.split("=")[1]);
                spaceKey = this.spaceManager.getSpaceFromPageId((long)pageId);
                break;
            }
            String allowed = (String)pluginSettings.get("d42_restrict_spaces");
            String enable = (String)pluginSettings.get("d42_restrict_spaces_enable");
            if (enable != null && enable.equals("on")) {
                if (allowed == null || allowed.trim().isEmpty()) {
                    this.sendAccessDeniedError(httpResponse);
                    return;
                }
                String[] allowedSpaces = allowed.split(",");
                boolean isAllowed = Arrays.asList(allowedSpaces).contains(spaceKey);
                if (!isAllowed) {
                    this.sendAccessDeniedError(httpResponse);
                    return;
                }
            }
        }
        catch (MalformedURLException e) {
            log.error("Error parsing referer URL in D42ConfluenceRestrictFilter: {}", (Object)referer, (Object)e);
            this.sendAccessDeniedError(httpResponse);
            return;
        }
        catch (NumberFormatException e) {
            log.error("Error parsing pageId or other numeric parameter in D42ConfluenceRestrictFilter from referer: {}", (Object)referer, (Object)e);
            this.sendAccessDeniedError(httpResponse);
            return;
        }
        catch (RuntimeException e) {
            log.error("Unexpected runtime error in D42ConfluenceRestrictFilter while processing referer: {}", (Object)referer, (Object)e);
            this.sendAccessDeniedError(httpResponse);
            return;
        }
        catch (Exception e) {
            log.error("Unexpected exception in D42ConfluenceRestrictFilter while processing referer: {}", (Object)referer, (Object)e);
            this.sendAccessDeniedError(httpResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void sendAccessDeniedError(HttpServletResponse httpResponse) throws IOException {
        httpResponse.sendError(403, "Access denied! You don't have access to this space. Please, ask your system administrator");
    }

    public void destroy() {
    }
}

